/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.mixin;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeSerializer;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SequencedRecipe.class})
public abstract class MixinSequencedAssemblyRecipe<T extends ProcessingRecipe<?>, R extends TieredProcessingRecipe<?>> {
    @Shadow(remap=false)
    private T wrapped;

    @Inject(method={"writeToBuffer"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void greate_writeToBuffer(FriendlyByteBuf buffer, CallbackInfo ci) {
        if (this.wrapped.m_7707_() instanceof ProcessingRecipeSerializer) {
            ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)this.wrapped.m_7707_();
            buffer.m_130085_(CatnipServices.REGISTRIES.getKeyOrThrow((RecipeSerializer)serializer));
            buffer.m_130085_(this.wrapped.m_6423_());
            serializer.toNetwork(buffer, this.wrapped);
        } else if (this.wrapped.m_7707_() instanceof TieredProcessingRecipeSerializer) {
            TieredProcessingRecipeSerializer serializer = (TieredProcessingRecipeSerializer)this.wrapped.m_7707_();
            buffer.m_130085_(CatnipServices.REGISTRIES.getKeyOrThrow((RecipeSerializer)serializer));
            buffer.m_130085_(this.wrapped.m_6423_());
            serializer.toNetwork(buffer, (TieredProcessingRecipe)((Object)this.wrapped));
        }
        ci.cancel();
    }

    @Inject(method={"readFromBuffer"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void greate_readFromBuffer(FriendlyByteBuf buffer, CallbackInfoReturnable<SequencedRecipe<?>> cir) {
        ResourceLocation loc = buffer.m_130281_();
        ResourceLocation loc1 = buffer.m_130281_();
        RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(loc);
        if (serializer instanceof ProcessingRecipeSerializer) {
            ProcessingRecipeSerializer prs = (ProcessingRecipeSerializer)serializer;
            ProcessingRecipe recipe = prs.fromNetwork(loc1, buffer);
            cir.setReturnValue((Object)new SequencedRecipe(recipe));
        } else if (serializer instanceof TieredProcessingRecipeSerializer) {
            TieredProcessingRecipeSerializer tprs = (TieredProcessingRecipeSerializer)serializer;
            Object recipe = tprs.fromNetwork(loc1, buffer);
            cir.setReturnValue((Object)new SequencedRecipe(recipe));
        } else {
            throw new JsonParseException("Not a supported recipe type");
        }
        cir.cancel();
    }
}

