/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.girder.ConnectedGirderModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import electrolyte.greate.Greate;
import electrolyte.greate.content.decoration.encasing.GirderEncasingRegistry;
import electrolyte.greate.content.decoration.girder.GreateGirderBlockStateGenerator;
import electrolyte.greate.content.decoration.girder.TieredGirderEncasedShaftBlock;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.gtceu.material.KineticProperty;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.Shafts;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Girders {
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredGirderEncasedShaftBlock>> GIRDERS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<TieredGirderEncasedShaftBlock>> GIRDERS;

    public static void register() {
        Greate.REGISTRATE.setCreativeTab(Greate.GREATE_TAB);
        Girders.generateGirders();
    }

    public static void generateGirders() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry girderEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("metal_girder_encased_" + mat.getName() + "_shaft", p -> new TieredGirderEncasedShaftBlock((BlockBehaviour.Properties)p, mat)).initialProperties(SharedProperties::softMetal).blockstate(GreateGirderBlockStateGenerator::blockStateWithShaft).properties(p -> p.m_284180_(MapColor.f_283818_)).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).loot((p, b) -> p.m_247577_((Block)b, p.m_247033_((ItemLike)AllBlocks.METAL_GIRDER.get()).m_79161_((LootPool.Builder)p.m_247733_((ItemLike)Objects.requireNonNull((BlockEntry)Shafts.NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat)), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Objects.requireNonNull((BlockEntry)Shafts.NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat))))))))).onRegister(CreateRegistrate.blockModel(() -> ConnectedGirderModel::new))).onRegister(c -> c.setTier(tier))).transform(GirderEncasingRegistry.addVariantTo((Supplier)Shafts.NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat)))).register();
            GIRDERS_BUILDER.put((Object)GreateTagPrefixes.girderEncasedShaft, (Object)mat, (Object)girderEntry);
        }
        GIRDERS = GIRDERS_BUILDER.build();
    }
}

