/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.gtceu.material.KineticProperty;
import electrolyte.greate.content.kinetics.simpleRelays.TieredShaftBlock;
import electrolyte.greate.content.kinetics.simpleRelays.encased.TieredEncasedShaftBlock;
import electrolyte.greate.content.kinetics.steamEngine.TieredPoweredShaftBlock;
import electrolyte.greate.foundation.data.GreateBlockStateGen;
import electrolyte.greate.foundation.data.GreateBuilderTransformers;
import electrolyte.greate.infrastructure.config.GStress;
import electrolyte.greate.registry.GreateTagPrefixes;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class Shafts {
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredShaftBlock>> SHAFTS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredPoweredShaftBlock>> POWERED_SHAFTS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedShaftBlock>> ANDESITE_ENCASED_SHAFTS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedShaftBlock>> BRASS_ENCASED_SHAFTS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<TieredShaftBlock>> NEW_SHAFTS;
    public static Table<TagPrefix, Material, BlockEntry<TieredPoweredShaftBlock>> POWERED_SHAFTS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedShaftBlock>> ANDESITE_ENCASED_SHAFTS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedShaftBlock>> BRASS_ENCASED_SHAFTS;

    public static void register() {
        Greate.REGISTRATE.setCreativeTab(Greate.GREATE_TAB);
        Shafts.generateShafts();
        Shafts.generatePoweredShafts();
        Shafts.generateAndesiteEncasedShafts();
        Shafts.generateBrassEncasedShafts();
    }

    public static void generateShafts() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry shaftEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block(mat.getName() + "_shaft", p -> new TieredShaftBlock((BlockBehaviour.Properties)p, mat)).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283906_)).transform(GStress.setNoImpact())).transform(TagGen.pickaxeOnly())).transform(GTBlocks.unificationBlock((TagPrefix)GreateTagPrefixes.shaft, (Material)mat))).blockstate(GreateBlockStateGen.tieredShaftProvider()).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).onRegister(c -> c.setTier(tier))).simpleItem().item().build()).register();
            SHAFTS_BUILDER.put((Object)GreateTagPrefixes.shaft, (Object)mat, (Object)shaftEntry);
        }
        NEW_SHAFTS = SHAFTS_BUILDER.build();
    }

    public static void generatePoweredShafts() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry shaftEntry = ((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("powered_" + mat.getName() + "_shaft", p -> new TieredPoweredShaftBlock((BlockBehaviour.Properties)p, mat)).initialProperties(SharedProperties::stone).properties(p -> p.m_284180_(MapColor.f_283906_)).transform(TagGen.pickaxeOnly())).blockstate(GreateBlockStateGen.tieredPoweredShaftProvider()).loot((l, b) -> l.m_246125_((Block)b, (ItemLike)Objects.requireNonNull((BlockEntry)NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat)))).onRegister(c -> c.setTier(tier))).register();
            POWERED_SHAFTS_BUILDER.put((Object)GreateTagPrefixes.poweredShaft, (Object)mat, (Object)shaftEntry);
        }
        POWERED_SHAFTS = POWERED_SHAFTS_BUILDER.build();
    }

    public static void generateAndesiteEncasedShafts() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry shaftEntry = Objects.requireNonNull((BlockEntry)NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat));
            BlockEntry encasedShaftEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("andesite_encased_" + mat.getName() + "_shaft", p -> new TieredEncasedShaftBlock((BlockBehaviour.Properties)p, mat, () -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get())).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedShaft((BlockEntry<TieredShaftBlock>)shaftEntry, () -> AllSpriteShifts.ANDESITE_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)shaftEntry))).transform(TagGen.axeOrPickaxe())).onRegister(c -> c.setTier(tier))).register();
            ANDESITE_ENCASED_SHAFTS_BUILDER.put((Object)GreateTagPrefixes.andesiteEncasedShaft, (Object)mat, (Object)encasedShaftEntry);
        }
        ANDESITE_ENCASED_SHAFTS = ANDESITE_ENCASED_SHAFTS_BUILDER.build();
    }

    public static void generateBrassEncasedShafts() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry shaftEntry = Objects.requireNonNull((BlockEntry)NEW_SHAFTS.get((Object)GreateTagPrefixes.shaft, (Object)mat));
            BlockEntry encasedShaftEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("brass_encased_" + mat.getName() + "_shaft", p -> new TieredEncasedShaftBlock((BlockBehaviour.Properties)p, mat, () -> ((BlockEntry)AllBlocks.BRASS_CASING).get())).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedShaft((BlockEntry<TieredShaftBlock>)shaftEntry, () -> AllSpriteShifts.BRASS_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)shaftEntry))).transform(TagGen.axeOrPickaxe())).onRegister(c -> c.setTier(tier))).register();
            BRASS_ENCASED_SHAFTS_BUILDER.put((Object)GreateTagPrefixes.brassEncasedShaft, (Object)mat, (Object)encasedShaftEntry);
        }
        BRASS_ENCASED_SHAFTS = BRASS_ENCASED_SHAFTS_BUILDER.build();
    }
}

