/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei;

import com.google.common.base.Predicates;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.BlockEntry;
import electrolyte.greate.Greate;
import electrolyte.greate.compat.jei.category.GreateRecipeCategory;
import electrolyte.greate.compat.jei.category.TieredBlockCuttingCategory;
import electrolyte.greate.compat.jei.category.TieredCrushingCategory;
import electrolyte.greate.compat.jei.category.TieredFanHauntingCategory;
import electrolyte.greate.compat.jei.category.TieredFanWashingCategory;
import electrolyte.greate.compat.jei.category.TieredMillingCategory;
import electrolyte.greate.compat.jei.category.TieredMixingCategory;
import electrolyte.greate.compat.jei.category.TieredPackingCategory;
import electrolyte.greate.compat.jei.category.TieredPressingCategory;
import electrolyte.greate.compat.jei.category.TieredSawingCategory;
import electrolyte.greate.content.kinetics.crusher.TieredAbstractCrushingRecipe;
import electrolyte.greate.content.kinetics.fan.TieredEncasedFanBlock;
import electrolyte.greate.content.kinetics.fan.processing.TieredHauntingRecipe;
import electrolyte.greate.content.kinetics.fan.processing.TieredSplashingRecipe;
import electrolyte.greate.content.kinetics.press.TieredPressingRecipe;
import electrolyte.greate.content.kinetics.saw.TieredCuttingRecipe;
import electrolyte.greate.content.processing.basin.TieredBasinRecipe;
import electrolyte.greate.registry.CrushingWheels;
import electrolyte.greate.registry.EncasedFans;
import electrolyte.greate.registry.MechanicalMixers;
import electrolyte.greate.registry.MechanicalPresses;
import electrolyte.greate.registry.Millstones;
import electrolyte.greate.registry.ModRecipeTypes;
import electrolyte.greate.registry.Saws;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.lang.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.IShapedRecipe;

@ParametersAreNonnullByDefault
@JeiPlugin
public class GreateJEI
implements IModPlugin {
    private static final ResourceLocation ID = Greate.id("jei_plugin");
    private final List<GreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    private void loadCategories() {
        this.allCategories.clear();
        GreateRecipeCategory<TieredAbstractCrushingRecipe> milling = this.builder(TieredAbstractCrushingRecipe.class).addTypedRecipes(ModRecipeTypes.MILLING).catalysts(Millstones.MILLSTONES).doubleIconItem((ItemLike)Millstones.NEUTRONIUM_MILLSTONE.get(), (ItemLike)AllItems.WHEAT_FLOUR.get()).emptyBackground(177, 78).build("milling", TieredMillingCategory::new);
        GreateRecipeCategory crushing = this.builder(TieredAbstractCrushingRecipe.class).addTypedRecipes(ModRecipeTypes.CRUSHING::getType).addTypedRecipesExcluding(ModRecipeTypes.MILLING::getType, ModRecipeTypes.CRUSHING::getType).catalysts(CrushingWheels.CRUSHING_WHEELS).doubleIconItem((ItemLike)CrushingWheels.NEUTRONIUM_CRUSHING_WHEEL.get(), (ItemLike)AllItems.CRUSHED_GOLD.get()).emptyBackground(177, 125).build("crushing", TieredCrushingCategory::new);
        GreateRecipeCategory washing = this.builder(TieredSplashingRecipe.class).addTypedRecipes(ModRecipeTypes.SPLASHING::getType).catalysts(EncasedFans.FANS).doubleIconItem((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42447_).emptyBackground(178, 87).build("fan_washing", TieredFanWashingCategory::new);
        GreateRecipeCategory haunting = this.builder(TieredHauntingRecipe.class).addTypedRecipes(ModRecipeTypes.HAUNTING::getType).catalysts(EncasedFans.FANS).doubleIconItem((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42782_).emptyBackground(178, 87).build("fan_haunting", TieredFanHauntingCategory::new);
        GreateRecipeCategory pressing = this.builder(TieredPressingRecipe.class).addTypedRecipes(ModRecipeTypes.PRESSING::getType).catalysts(MechanicalPresses.MECHANICAL_PRESSES).doubleIconItem((ItemLike)MechanicalPresses.NEUTRONIUM_MECHANICAL_PRESS.get(), (ItemLike)AllItems.IRON_SHEET.get()).emptyBackground(177, 85).build("pressing", TieredPressingCategory::new);
        GreateRecipeCategory mixing = this.builder(TieredBasinRecipe.class).addTypedRecipes(ModRecipeTypes.MIXING::getType).catalysts(MechanicalMixers.MECHANICAL_MIXERS).doubleIconItem((ItemLike)MechanicalMixers.NEUTRONIUM_MECHANICAL_MIXER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 118).build("mixing", TieredMixingCategory::standard);
        GreateRecipeCategory<TieredBasinRecipe> autoShapeless = this.builder(TieredBasinRecipe.class).enableWhen(c -> c.allowShapelessInMixer).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && r.m_7527_().size() > 1 && !MechanicalPressBlockEntity.canCompress((Recipe)r) && !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r) && !ModRecipeTypes.shouldIgnoreInAutomation(r), TieredBasinRecipe::convertShapeless).catalysts(MechanicalMixers.MECHANICAL_MIXERS).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleIconItem((ItemLike)MechanicalMixers.NEUTRONIUM_MECHANICAL_MIXER, (ItemLike)Items.f_41960_).emptyBackground(177, 100).build("automatic_shapeless", TieredMixingCategory::autoShapeless);
        GreateRecipeCategory brewing = this.builder(TieredBasinRecipe.class).enableWhen(c -> c.allowBrewingInMixer).addTypedRecipes(ModRecipeTypes.BREWING::getType).catalysts(MechanicalMixers.MECHANICAL_MIXERS).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleIconItem((ItemLike)MechanicalMixers.NEUTRONIUM_MECHANICAL_MIXER.get(), (ItemLike)Blocks.f_50255_).emptyBackground(177, 118).build("automatic_brewing", TieredMixingCategory::autoBrewing);
        GreateRecipeCategory packing = this.builder(TieredBasinRecipe.class).addTypedRecipes(ModRecipeTypes.COMPACTING::getType).catalysts(MechanicalPresses.MECHANICAL_PRESSES).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleIconItem((ItemLike)MechanicalPresses.NEUTRONIUM_MECHANICAL_PRESS.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 118).build("packing", TieredPackingCategory::standard);
        GreateRecipeCategory<TieredBasinRecipe> autoSquare = this.builder(TieredBasinRecipe.class).enableWhen(c -> c.allowShapedSquareInPress).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof MechanicalCraftingRecipe) && MechanicalPressBlockEntity.canCompress((Recipe)r) && !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r) && !ModRecipeTypes.shouldIgnoreInAutomation(r), TieredBasinRecipe::convertShapeless).catalysts(MechanicalPresses.MECHANICAL_PRESSES).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleIconItem((ItemLike)MechanicalPresses.NEUTRONIUM_MECHANICAL_PRESS, (ItemLike)Blocks.f_50091_).emptyBackground(177, 100).build("automatic_packing", TieredPackingCategory::autoSquare);
        GreateRecipeCategory sawing = this.builder(TieredCuttingRecipe.class).addTypedRecipes(ModRecipeTypes.CUTTING::getType).catalysts(Saws.SAWS).doubleIconItem((ItemLike)Saws.NEUTRONIUM_SAW, (ItemLike)Items.f_41837_).emptyBackground(177, 85).build("sawing", TieredSawingCategory::new);
        GreateRecipeCategory blockCutting = this.builder(TieredBlockCuttingCategory.TieredCondensedBlockCuttingRecipe.class).enableWhen(c -> c.allowStonecuttingOnSaw).addRecipes(() -> TieredBlockCuttingCategory.condenseRecipes(GreateJEI.getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType.f_44112_, Predicates.or(AllRecipeTypes::shouldIgnoreInAutomation, ModRecipeTypes::shouldIgnoreInAutomation)))).catalysts(Saws.SAWS).doubleIconItem((ItemLike)Saws.NEUTRONIUM_SAW.get(), (ItemLike)Items.f_42092_).emptyBackground(177, 70).build("block_cutting", TieredBlockCuttingCategory::new);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"milling", AbstractCrushingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"crushing", AbstractCrushingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"pressing", PressingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"mixing", BasinRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"automatic_shapeless", BasinRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"automatic_brewing", BasinRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"packing", BasinRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"automatic_packing", BasinRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"sawing", CuttingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"block_cutting", BlockCuttingCategory.CondensedBlockCuttingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"fan_haunting", HauntingRecipe.class));
        registration.getRecipeManager().hideRecipeCategory(RecipeType.create((String)"create", (String)"fan_washing", SplashingRecipe.class));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        for (BlockEntry<TieredEncasedFanBlock> fan : EncasedFans.FANS) {
            registration.addRecipeCatalyst(fan.asStack(), new RecipeType[]{RecipeType.create((String)"create", (String)"fan_blasting", AbstractCookingRecipe.class)});
            registration.addRecipeCatalyst(fan.asStack(), new RecipeType[]{RecipeType.create((String)"create", (String)"fan_smoking", SmokingRecipe.class)});
        }
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Minecraft.m_91087_().m_91403_().m_105141_().m_44051_().forEach(consumer);
    }

    public static <T extends Recipe<?>> void consumeTypedRecipes(Consumer<T> consumer, net.minecraft.world.item.crafting.RecipeType<?> type) {
        Map map = (Map)Minecraft.m_91087_().m_91403_().m_105141_().f_44007_.get(type);
        if (map != null) {
            map.values().forEach(recipe -> consumer.accept(recipe));
        }
    }

    public static List<Recipe<?>> getTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
        ArrayList recipes = new ArrayList();
        GreateJEI.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<Recipe<?>> getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPredicate) {
        List<Recipe<?>> recipes = GreateJEI.getTypedRecipes(type);
        recipes.removeIf(exclusionPredicate);
        return recipes;
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
    }

    public static boolean doOutputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        return ItemStack.m_41656_((ItemStack)recipe1.m_8043_(registryAccess), (ItemStack)recipe2.m_8043_(registryAccess));
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> predicate) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeAllRecipes(recipe -> {
                if (predicate.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> predicate, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeAllRecipes(recipe -> {
                if (predicate.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesGT(GTRecipeType recipeType, Function<GTRecipe, T> converter) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((GTRecipe)recipe)), recipeType));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> predicate) {
            return this.addRecipeListConsumer(recipes -> GreateJEI.consumeTypedRecipes(recipe -> {
                if (predicate.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = GreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                GreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!GreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get());
            });
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = GreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                GreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!GreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get());
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = GreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!GreateJEI.doInputsMatch(recipe, excludedRecipe) || !GreateJEI.doOutputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public final CategoryBuilder<T> catalystStacks(Collection<Supplier<ItemStack>> suppliers) {
            this.catalysts.addAll(suppliers);
            return this;
        }

        @SafeVarargs
        public final CategoryBuilder<T> catalystStacks(Supplier<ItemStack> ... suppliers) {
            this.catalysts.addAll(List.of(suppliers));
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> catalysts(Collection<Supplier<ItemLike>> suppliers) {
            return this.catalystStacks(suppliers.stream().map(supplier -> () -> CategoryBuilder.lambda$catalysts$21((Supplier)supplier)).collect(Collectors.toList()));
        }

        @SafeVarargs
        public final CategoryBuilder<T> catalysts(Supplier<ItemLike> ... suppliers) {
            return this.catalystStacks(Arrays.stream(suppliers).map(supplier -> () -> CategoryBuilder.lambda$catalysts$23((Supplier)supplier)).collect(Collectors.toList()));
        }

        public final CategoryBuilder<T> catalysts(BlockEntry<?>[] blocks) {
            return this.catalystStacks(Arrays.stream(blocks).map(s -> () -> new ItemStack((ItemLike)((Block)s.get()).m_5456_())).toList());
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleIconItem(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int with, int height) {
            this.background((IDrawable)new EmptyBackground(with, height));
            return this;
        }

        public GreateRecipeCategory<T> build(String name, GreateRecipeCategory.Factory<T> factory) {
            Supplier<List<Object>> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            GreateRecipeCategory.Info info = new GreateRecipeCategory.Info(new RecipeType(Greate.id(name), this.recipeClass), (Component)Lang.builder((String)"greate").translate("recipe." + name, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
            GreateRecipeCategory<T> category = factory.create(info);
            GreateJEI.this.allCategories.add(category);
            return category;
        }

        private static /* synthetic */ ItemStack lambda$catalysts$23(Supplier supplier) {
            return new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_());
        }

        private static /* synthetic */ ItemStack lambda$catalysts$21(Supplier supplier) {
            return new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_());
        }
    }
}

