/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei.category;

import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class GreateRecipeCategory<T extends Recipe<?>>
implements IRecipeCategory<T> {
    private static final IDrawable BASIC_SLOT = GreateRecipeCategory.asDrawable(AllGuiTextures.JEI_SLOT);
    private static final IDrawable CHANCE_SLOT = GreateRecipeCategory.asDrawable(AllGuiTextures.JEI_CHANCE_SLOT);
    protected final RecipeType<T> type;
    protected final Component title;
    protected final IDrawable background;
    protected final IDrawable icon;
    private final Supplier<List<T>> recipes;
    private final List<Supplier<? extends ItemStack>> catalysts;

    public GreateRecipeCategory(Info<T> info) {
        this.type = info.recipeType();
        this.title = info.title();
        this.background = info.background();
        this.icon = info.icon();
        this.recipes = info.recipes();
        this.catalysts = info.catalysts();
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(this.type, this.recipes.get());
    }

    public void registerCatalysts(IRecipeCatalystRegistration registration) {
        this.catalysts.forEach(s -> registration.addRecipeCatalyst((ItemStack)s.get(), new RecipeType[]{this.type}));
    }

    public static IDrawable getRenderedSlot() {
        return BASIC_SLOT;
    }

    public static IDrawable getRenderedSlot(ProcessingOutput output) {
        return GreateRecipeCategory.getRenderedSlot(output.getChance());
    }

    public static IDrawable getRenderedSlot(float chance) {
        if (chance == 1.0f) {
            return BASIC_SLOT;
        }
        return CHANCE_SLOT;
    }

    public static ItemStack getCircuitStack(TieredProcessingRecipe<?> recipe) {
        if (recipe.getCircuitNumber() == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack circuitStack = new ItemStack((ItemLike)GTItems.PROGRAMMED_CIRCUIT);
        IntCircuitBehaviour.setCircuitConfiguration((ItemStack)circuitStack, (int)recipe.getCircuitNumber());
        return circuitStack;
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(GreateRecipeCategory::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        int displayedAmount = (int)((float)stack.getAmount() * 0.75f) + 250;
        display.setAmount(displayedAmount);
        return display;
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            if (fluidStack.getFluid().m_6212_((Fluid)AllFluids.POTION.get())) {
                Component name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList potionTooltip = new ArrayList();
                PotionFluidHandler.addPotionTooltip((FluidStack)fluidStack, potionTooltip, (float)1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Component.m_237113_((String)String.valueOf(amount)).m_7220_((Component)CreateLang.translateDirect((String)"generic.unit.millibuckets", (Object[])new Object[0])).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }

    protected static IDrawable asDrawable(final AllGuiTextures texture) {
        return new IDrawable(){

            public int getWidth() {
                return texture.getWidth();
            }

            public int getHeight() {
                return texture.getHeight();
            }

            public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
                texture.render(graphics, xOffset, yOffset);
            }
        };
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double x, double y) {
        super.draw(recipe, recipeSlotsView, graphics, x, y);
        graphics.drawString(Minecraft.m_91087_().f_91062_, Lang.builder((String)"greate").translate("jei.recipe_tier", new Object[0]).component().getString() + GreateValues.SN[((TieredProcessingRecipe)((Object)recipe)).getRecipeTier()], (float)x, (float)y, 0x3F3F3F, false);
    }

    public record Info<T extends Recipe<?>>(RecipeType<T> recipeType, Component title, IDrawable background, IDrawable icon, Supplier<List<T>> recipes, List<Supplier<? extends ItemStack>> catalysts) {
    }

    public static interface Factory<T extends Recipe<?>> {
        public GreateRecipeCategory<T> create(Info<T> var1);
    }
}

