/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei.category;

import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import electrolyte.greate.compat.jei.category.GreateRecipeCategory;
import electrolyte.greate.compat.jei.category.TieredBasinCategory;
import electrolyte.greate.compat.jei.category.animations.TieredAnimatedMixer;
import electrolyte.greate.content.kinetics.mixer.TieredMechanicalMixerBlock;
import electrolyte.greate.content.processing.basin.TieredBasinRecipe;
import electrolyte.greate.registry.MechanicalMixers;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import net.minecraft.client.gui.GuiGraphics;

@ParametersAreNonnullByDefault
public class TieredMixingCategory
extends TieredBasinCategory {
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    MixingType type;

    public static TieredMixingCategory standard(GreateRecipeCategory.Info<TieredBasinRecipe> info) {
        return new TieredMixingCategory(info, MixingType.MIXING);
    }

    public static TieredMixingCategory autoShapeless(GreateRecipeCategory.Info<TieredBasinRecipe> info) {
        return new TieredMixingCategory(info, MixingType.AUTO_SHAPELESS);
    }

    public static TieredMixingCategory autoBrewing(GreateRecipeCategory.Info<TieredBasinRecipe> info) {
        return new TieredMixingCategory(info, MixingType.AUTO_BREWING);
    }

    protected TieredMixingCategory(GreateRecipeCategory.Info<TieredBasinRecipe> info, MixingType type) {
        super(info, type != MixingType.AUTO_SHAPELESS);
        this.type = type;
    }

    @Override
    public void draw(TieredBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double x, double y) {
        boolean mixingType = this.type == MixingType.AUTO_SHAPELESS;
        double yOffset = mixingType ? 90.0 : 107.0;
        super.draw(recipe, recipeSlotsView, graphics, 1.0, yOffset);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        new TieredAnimatedMixer((TieredMechanicalMixerBlock)MechanicalMixers.MECHANICAL_MIXERS[recipe.getRecipeTier()].get()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
    }

    protected static enum MixingType {
        MIXING,
        AUTO_SHAPELESS,
        AUTO_BREWING;

    }
}

