/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.compat.jei.category.GreateRecipeCategory;
import electrolyte.greate.content.kinetics.fan.TieredEncasedFanBlock;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.registry.EncasedFans;
import electrolyte.greate.registry.GreatePartialModels;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public abstract class TieredProcessingViaFanCategory<T extends Recipe<?>>
extends GreateRecipeCategory<T> {
    protected static final int SCALE = 24;

    public TieredProcessingViaFanCategory(GreateRecipeCategory.Info<T> info) {
        super(info);
    }

    public static Supplier<ItemStack> getFan(BlockEntry<TieredEncasedFanBlock> fan, String name) {
        return () -> fan.asStack().m_41714_((Component)CreateLang.translateDirect((String)("recipe." + name + ".fan"), (Object[])new Object[0]).m_130938_(s -> s.m_131155_(Boolean.valueOf(false))));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 48).setBackground(TieredProcessingViaFanCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 141, 48).setBackground(TieredProcessingViaFanCategory.getRenderedSlot(), -1, -1).addItemStack(CreateRecipeCategory.getResultItem(recipe));
    }

    @Override
    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double x, double y) {
        super.draw(recipe, recipeSlotsView, graphics, 1.0, 77.0);
        this.renderWidgets(graphics, recipe, x, y);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        this.translateFan(poseStack);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-12.5f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        PartialModel fanInner = AllPartialModels.ENCASED_FAN_INNER;
        BlockState fanState = AllBlocks.ENCASED_FAN.getDefaultState();
        if (recipe instanceof TieredProcessingRecipe) {
            TieredProcessingRecipe tpr = (TieredProcessingRecipe)((Object)recipe);
            fanInner = GreatePartialModels.FAN_INNER_MODELS[tpr.getRecipeTier()];
            fanState = EncasedFans.FANS[tpr.getRecipeTier()].getDefaultState();
        }
        AnimatedKinetics.defaultBlockElement((PartialModel)fanInner).rotateBlock(180.0, 0.0, (double)(AnimatedKinetics.getCurrentAngle() * 16.0f)).scale(24.0).render(graphics);
        AnimatedKinetics.defaultBlockElement((BlockState)fanState).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(graphics);
        this.renderAttachedBlock(graphics);
        poseStack.m_85849_();
    }

    protected void renderWidgets(GuiGraphics graphics, T recipe, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 46, 29);
        this.getBlockShadow().render(graphics, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 54, 51);
    }

    protected AllGuiTextures getBlockShadow() {
        return AllGuiTextures.JEI_SHADOW;
    }

    protected void translateFan(PoseStack poseStack) {
        poseStack.m_252880_(56.0f, 33.0f, 0.0f);
    }

    protected abstract void renderAttachedBlock(GuiGraphics var1);

    public static abstract class TieredMultiOutput<T extends TieredProcessingRecipe<?>>
    extends TieredProcessingViaFanCategory<T> {
        public TieredMultiOutput(GreateRecipeCategory.Info<T> info) {
            super(info);
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
            NonNullList<ProcessingOutput> results = ((TieredProcessingRecipe)((Object)recipe)).getRollableResults();
            int xOffsetAmount = 1 - Math.min(3, results.size());
            builder.addSlot(RecipeIngredientRole.INPUT, 5 * xOffsetAmount + 21, 48).setBackground(TieredMultiOutput.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
            int i = 0;
            boolean excessive = results.size() > 9;
            for (ProcessingOutput output : results) {
                int xOffset = i % 3 * 19 + 9 * xOffsetAmount;
                int yOffset = i / 3 * -19 + (excessive ? 8 : 0);
                IRecipeSlotBuilder baseBuilder = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 141 + xOffset, 48 + yOffset).setBackground(TieredMultiOutput.getRenderedSlot(output), -1, -1).addItemStack(output.getStack());
                baseBuilder.addRichTooltipCallback(CreateRecipeCategory.addStochasticTooltip((ProcessingOutput)output));
                ++i;
            }
        }

        @Override
        protected void renderWidgets(GuiGraphics graphics, T recipe, double mouseX, double mouseY) {
            int size = recipe.getRollableResultsAsItemStacks().size();
            int xOffsetAmount = 1 - Math.min(3, size);
            AllGuiTextures.JEI_SHADOW.render(graphics, 46, 29);
            this.getBlockShadow().render(graphics, 46, 29);
            AllGuiTextures.JEI_LONG_ARROW.render(graphics, 7 * xOffsetAmount + 54, 51);
        }
    }
}

