/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.compat.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.kjs.recipe.GTRecipeSchema;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMap;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ContentJS;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.GTRecipeComponents;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.create.ProcessingRecipeSchema;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import electrolyte.greate.Greate;
import electrolyte.greate.GreateValues;
import electrolyte.greate.compat.kubejs.TieredProcessingRecipeSchema;
import electrolyte.greate.content.gtceu.material.GreateMaterialFlags;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeSerializer;
import electrolyte.greate.foundation.data.recipe.GreateCraftingComponents;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public class KubeJSGreatePlugin
extends KubeJSPlugin {
    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        if (!ModList.get().isLoaded("kubejs_create")) {
            return;
        }
        Map<ModRecipeTypes, RecipeSchema> RECIPE_SCHEMAS = Map.of(ModRecipeTypes.MILLING, TieredProcessingRecipeSchema.PROCESSING_WITH_TIME, ModRecipeTypes.CRUSHING, TieredProcessingRecipeSchema.PROCESSING_WITH_TIME, ModRecipeTypes.PRESSING, TieredProcessingRecipeSchema.PROCESSING_WITH_CIRCUIT, ModRecipeTypes.COMPACTING, TieredProcessingRecipeSchema.PROCESSING_WITH_CIRCUIT, ModRecipeTypes.MIXING, TieredProcessingRecipeSchema.PROCESSING_WITH_CIRCUIT, ModRecipeTypes.BASIN, TieredProcessingRecipeSchema.PROCESSING_WITH_CIRCUIT);
        for (ModRecipeTypes recipeType : ModRecipeTypes.values()) {
            if (!(recipeType.getSerializer() instanceof TieredProcessingRecipeSerializer)) continue;
            RecipeSchema schema = RECIPE_SCHEMAS.getOrDefault((Object)recipeType, TieredProcessingRecipeSchema.PROCESSING_DEFAULT);
            event.register(recipeType.getId(), schema);
        }
    }

    public void registerBindings(BindingsEvent event) {
        event.add("GreateValues", GreateValues.class);
        event.add("GreateCraftingComponents", GreateCraftingComponents.class);
        event.add("GreateMaterialFlags", GreateMaterialFlags.class);
        event.add("GreatePropertyKeys", GreatePropertyKeys.class);
    }

    public void injectRuntimeRecipes(RecipesEventJS event, RecipeManager manager, Map<ResourceLocation, Recipe<?>> recipesByName) {
        for (RecipeJS r : event.addedRecipes) {
            ProcessingRecipeSchema.ProcessingRecipeJS processingRecipeJS;
            TieredProcessingRecipeBuilder builder;
            TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<TieredProcessingRecipe<?>> factory;
            if (r.getId().endsWith("_manual_only") || r.getId().endsWith("_electric_only")) continue;
            if (r instanceof GTRecipeSchema.GTRecipeJS) {
                Map<RecipeCapability, List> inputs;
                GTRecipeSchema.GTRecipeJS gtRecipeJS = (GTRecipeSchema.GTRecipeJS)r;
                factory = GreateValues.getFactory(gtRecipeJS.getType());
                if (factory == null) continue;
                builder = new TieredProcessingRecipeBuilder(factory, Greate.id("integration/" + gtRecipeJS.idWithoutType().toString().replace(':', '/')));
                if (!r.getType().toString().startsWith(GTRecipeTypes.BENDER_RECIPES.registryName.toString())) {
                    if (gtRecipeJS.getValue(GTRecipeSchema.DURATION) != null) {
                        builder.duration(((Long)gtRecipeJS.getValue(GTRecipeSchema.DURATION)).intValue());
                    } else {
                        builder.averageProcessingDuration();
                    }
                }
                if (gtRecipeJS.getValue(GTRecipeSchema.ALL_INPUTS) != null) {
                    inputs = ((CapabilityMap)gtRecipeJS.getValue(GTRecipeSchema.ALL_INPUTS)).entrySet().stream().map(e -> Map.entry((RecipeCapability)e.getKey(), Arrays.stream((Content[])e.getValue()).map(c -> ((RecipeCapability)e.getKey()).serializer.fromJsonContent(((ContentJS)((Pair)GTRecipeComponents.VALID_CAPS.get(e.getKey())).getFirst()).write((RecipeJS)gtRecipeJS, c))).toList())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    inputs.forEach((recipeCapability, contents) -> {
                        if (recipeCapability instanceof ItemRecipeCapability) {
                            builder.withItemIngredientsGT((List<Content>)contents);
                            builder.recipeCircuit(TieredProcessingRecipe.getCircuitFromGTRecipe(contents));
                        }
                        if (recipeCapability instanceof FluidRecipeCapability) {
                            builder.withFluidIngredientsGT((List<Content>)contents);
                        }
                    });
                }
                if (gtRecipeJS.getValue(GTRecipeSchema.ALL_OUTPUTS) != null) {
                    Map<RecipeCapability, List> outputs = ((CapabilityMap)gtRecipeJS.getValue(GTRecipeSchema.ALL_OUTPUTS)).entrySet().stream().map(e -> Map.entry((RecipeCapability)e.getKey(), Arrays.stream((Content[])e.getValue()).map(c -> ((RecipeCapability)e.getKey()).serializer.fromJsonContent(((ContentJS)((Pair)GTRecipeComponents.VALID_CAPS.get(e.getKey())).getFirst()).write((RecipeJS)gtRecipeJS, c))).toList())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    outputs.forEach((recipeCapability, contents) -> {
                        if (recipeCapability instanceof ItemRecipeCapability) {
                            builder.withItemOutputsGT((List<Content>)contents);
                        }
                        if (recipeCapability instanceof FluidRecipeCapability) {
                            builder.withFluidOutputsGT((List<Content>)contents);
                        }
                    });
                }
                if (gtRecipeJS.getValue(GTRecipeSchema.ALL_TICK_INPUTS) != null) {
                    inputs = ((CapabilityMap)gtRecipeJS.getValue(GTRecipeSchema.ALL_TICK_INPUTS)).entrySet().stream().map(e -> Map.entry((RecipeCapability)e.getKey(), Arrays.stream((Content[])e.getValue()).map(c -> ((RecipeCapability)e.getKey()).serializer.fromJsonContent(((ContentJS)((Pair)GTRecipeComponents.VALID_CAPS.get(e.getKey())).getFirst()).write((RecipeJS)gtRecipeJS, c))).toList())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    inputs.forEach((recipeCapability, contents) -> {
                        if (recipeCapability instanceof EURecipeCapability) {
                            builder.recipeTier(GreateValues.convertGTEUToTier(contents));
                        }
                    });
                }
                builder.build(b -> recipesByName.put(b.m_6445_(), b.m_6637_().m_6729_(b.m_6445_(), b.m_125966_())));
                continue;
            }
            if (!(r instanceof ProcessingRecipeSchema.ProcessingRecipeJS) || (factory = GreateValues.getFactory((processingRecipeJS = (ProcessingRecipeSchema.ProcessingRecipeJS)r).getType())) == null) continue;
            builder = new TieredProcessingRecipeBuilder(factory, Greate.id("integration/" + processingRecipeJS.id.toString().replace(':', '/')));
            if (processingRecipeJS.json.has("heatRequirement")) {
                builder.requiresHeat(HeatCondition.deserialize((String)processingRecipeJS.json.get("heatRequirement").getAsString()));
            }
            JsonArray ingArr = processingRecipeJS.json.get("ingredients").getAsJsonArray();
            NonNullList itemIngredients = NonNullList.m_122779_();
            NonNullList fluidIngredients = NonNullList.m_122779_();
            ingArr.forEach(ing -> {
                if (FluidIngredient.isFluidIngredient((JsonElement)ing)) {
                    fluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)ing));
                } else {
                    itemIngredients.add((Object)Ingredient.m_43917_((JsonElement)ing));
                }
            });
            if (!itemIngredients.isEmpty()) {
                builder.withItemIngredients((NonNullList<Ingredient>)itemIngredients);
            }
            if (!fluidIngredients.isEmpty()) {
                builder.withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients);
            }
            JsonArray resultArr = processingRecipeJS.json.get("results").getAsJsonArray();
            NonNullList itemResults = NonNullList.m_122779_();
            NonNullList fluidResults = NonNullList.m_122779_();
            resultArr.forEach(result -> {
                if (FluidIngredient.isFluidIngredient((JsonElement)result)) {
                    fluidResults.add((Object)((FluidStack)FluidIngredient.deserialize((JsonElement)result).getMatchingFluidStacks().get(0)));
                } else {
                    int count = 1;
                    if (result.getAsJsonObject().has("count")) {
                        count = result.getAsJsonObject().get("count").getAsInt();
                    }
                    float chance = 1.0f;
                    if (result.getAsJsonObject().has("chance")) {
                        chance = result.getAsJsonObject().get("chance").getAsFloat();
                    }
                    itemResults.add((Object)new ProcessingOutput(Ingredient.m_43917_((JsonElement)result).m_43908_()[0].m_255036_(count), chance));
                }
            });
            if (!itemResults.isEmpty()) {
                builder.withItemOutputs((NonNullList<ProcessingOutput>)itemResults);
            }
            if (!fluidResults.isEmpty()) {
                builder.withFluidOutputs((NonNullList<FluidStack>)fluidResults);
            }
            builder.build(b -> recipesByName.put(b.m_6445_(), b.m_6637_().m_6729_(b.m_6445_(), b.m_125966_())));
        }
    }
}

