/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.fluids.pump;

import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import electrolyte.greate.content.fluids.pump.TieredPumpBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import electrolyte.greate.infrastructure.config.GConfigUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class TieredPumpBlockEntity
extends PumpBlockEntity
implements ITieredKineticBlockEntity {
    private final int tier;
    private static final Class<?> pumpFluidTransferBehaviourClass = PumpBlockEntity.class.getDeclaredClasses()[0];

    public TieredPumpBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.tier = ((TieredPumpBlock)state.m_60734_()).getTier();
    }

    public int getTier() {
        return this.tier;
    }

    protected void distributePressureTo(Direction side) {
        FluidTransportBehaviour pipeBehaviour;
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.f_58858_, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair> pipeGraph = new HashMap<BlockPos, Pair>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks((Level)this.f_58857_, (BlockPos)this.f_58858_, (Direction)side.m_122424_());
        }
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.f_58858_, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.m_122424_(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.f_58857_.m_46749_(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.f_58857_.m_8055_(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections((BlockState)currentState, (FluidTransportBehaviour)pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.f_58857_.m_46749_(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)connectedPos);
                    if (pipeBehaviour == null || pumpFluidTransferBehaviourClass.isAssignableFrom(pipeBehaviour.getClass()) || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.m_122424_(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap validFaces = new HashMap();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        double basePressure = GConfigUtility.getPumpPressureFromTier(this.tier);
        float pressure = (float)(basePressure * (double)Math.abs(this.getSpeed()));
        for (Set set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.f_58858_)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        LazyOptional capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.m_8055_(connectedPos);
        BlockEntity blockEntity = world.m_7702_(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == face.m_122434_() && blockEntity instanceof PumpBlockEntity) {
            PumpBlockEntity pumpBE = (PumpBlockEntity)blockEntity;
            return pumpBE.isPullingOnSide(TieredPumpBlockEntity.isFrontStatic(pumpBE, blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (blockEntity != null && (capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_())).isPresent()) {
            return true;
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, (BlockPos)blockFace.getPos(), (Direction)face);
    }

    private static boolean isFrontStatic(PumpBlockEntity pumpBE, Direction side) {
        BlockState blockState = pumpBE.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.m_61143_((Property)PumpBlock.FACING);
        return side == front;
    }
}

