/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.gtceu.material;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;

public class KineticProperty
implements IMaterialProperty {
    private int tier;
    private float impact;
    private float generatedCapacity;
    private float maxCapacity;

    public KineticProperty(int tier, float impact, float generatedCapacity, float maxCapacity) {
        this.tier = tier;
        this.impact = impact;
        this.generatedCapacity = generatedCapacity;
        this.maxCapacity = maxCapacity;
    }

    public KineticProperty(int tier, int maxCapacity) {
        this.tier = tier;
        this.impact = 0.0f;
        this.generatedCapacity = 0.0f;
        this.maxCapacity = maxCapacity;
    }

    public void verifyProperty(MaterialProperties materialProperties) {
        Material mat;
        if (materialProperties.hasProperty(PropertyKey.INGOT) && !(mat = materialProperties.getMaterial()).hasFlag(MaterialFlags.GENERATE_PLATE)) {
            mat.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_PLATE});
        }
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public float getImpact() {
        return this.impact;
    }

    public void setImpact(float impact) {
        this.impact = impact;
    }

    public float getGeneratedCapacity() {
        return this.generatedCapacity;
    }

    public void setGeneratedCapacity(float generatedCapacity) {
        this.generatedCapacity = generatedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(float maxCapacity) {
        this.maxCapacity = maxCapacity;
    }
}

