/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.kinetics.belt.ITieredBelt;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlockEntity;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.registry.GreateSpriteShifts;
import electrolyte.greate.registry.GreateTagPrefixes;
import electrolyte.greate.registry.ModBlockEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;

public class TieredBeltBlock
extends BeltBlock
implements ITieredBlock,
ITieredBelt {
    private int tier;
    private Material beltMaterial;

    public TieredBeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ChemicalHelper.get((TagPrefix)GreateTagPrefixes.beltConnector, (Material)this.beltMaterial);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pBuilder) {
        List drops = super.m_49635_(pState, pBuilder);
        BlockEntity be = (BlockEntity)pBuilder.m_287159_(LootContextParams.f_81462_);
        if (be instanceof TieredBeltBlockEntity) {
            TieredBeltBlockEntity tbe = (TieredBeltBlockEntity)be;
            if (tbe.hasPulley()) {
                drops.removeIf(s -> s.m_150930_(AllBlocks.SHAFT.m_5456_()));
                drops.add(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateValues.TM[this.tier]));
            }
            drops.add(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.beltConnector, (Material)this.beltMaterial));
        }
        return drops;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pLevel.f_46443_) {
            return;
        }
        if (pState.m_60734_() == pNewState.m_60734_()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState currentState;
            BlockPos currentPos = TieredBeltBlock.nextSegmentPosition((BlockState)pState, (BlockPos)pPos, (boolean)forward);
            if (currentPos == null || (currentState = pLevel.m_8055_(currentPos)).m_60734_() != this) continue;
            boolean hasPulley = false;
            BlockEntity be = pLevel.m_7702_(currentPos);
            if (be instanceof TieredBeltBlockEntity) {
                TieredBeltBlockEntity beltBE = (TieredBeltBlockEntity)be;
                if (beltBE.isController()) {
                    beltBE.getInventory().ejectAll();
                }
                hasPulley = beltBE.hasPulley();
            }
            pLevel.m_46747_(currentPos);
            BlockState shaftState = (BlockState)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateValues.TM[this.tier]).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.getRotationAxis(currentState));
            pLevel.m_7731_(currentPos, ProperWaterloggedBlock.withWater((LevelAccessor)pLevel, (BlockState)(hasPulley ? shaftState : Blocks.f_50016_.m_49966_()), (BlockPos)currentPos), 3);
            pLevel.m_46796_(2001, currentPos, Block.m_49956_((BlockState)currentState));
        }
    }

    public BlockEntityType<? extends TieredBeltBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntityTypes.TIERED_BELT.get();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.m_61143_(PART) != BeltPart.MIDDLE) {
            required.add(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateValues.TM[this.tier]));
        }
        if (state.m_61143_(PART) == BeltPart.START) {
            required.add(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.beltConnector, (Material)this.beltMaterial));
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setupBeltModel() {
        GreateSpriteShifts.populateMaps(this);
    }

    @Override
    public Material getBeltMaterial() {
        return this.beltMaterial;
    }

    @Override
    public void setBeltMaterial(Material material) {
        this.beltMaterial = material;
    }
}

