/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.belt;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltRenderer;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import electrolyte.greate.content.kinetics.belt.IBeltRenderHelper;
import electrolyte.greate.content.kinetics.belt.TieredBeltBlock;
import electrolyte.greate.registry.GreatePartialModels;
import electrolyte.greate.registry.GreateSpriteShifts;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TieredBeltRenderer
extends BeltRenderer
implements IBeltRenderHelper {
    public TieredBeltRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BeltBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            BlockState blockState = be.m_58900_();
            Block block = blockState.m_60734_();
            if (!(block instanceof TieredBeltBlock)) {
                return;
            }
            TieredBeltBlock tbb = (TieredBeltBlock)block;
            BeltSlope beltSlope = (BeltSlope)blockState.m_61143_(BeltBlock.SLOPE);
            BeltPart part = (BeltPart)blockState.m_61143_(BeltBlock.PART);
            Direction facing = (Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.m_122421_();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.m_122434_() == Direction.Axis.X;
            PoseStack localTransforms = new PoseStack();
            PoseTransformStack msr = TransformStack.of((PoseStack)localTransforms);
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110463_());
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0))).rotateZDegrees(sideways ? 90.0f : 0.0f)).rotateXDegrees(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0f : 0.0f)).uncenter();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == Direction.AxisDirection.POSITIVE) {
                boolean b = start;
                start = end;
                end = b;
            }
            DyeColor color = be.color.orElse(null);
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = TieredBeltRenderer.getBeltPartial(tbb, diagonal, start, end, bottom);
                PartialModel overlayPartial = TieredBeltRenderer.getOverlayPartial(diagonal, start, end, bottom);
                SuperByteBuffer beltBuffer = CachedBuffers.partial((PartialModel)beltPartial, (BlockState)blockState).light(light);
                SuperByteBuffer overlayBuffer = CachedBuffers.partial((PartialModel)overlayPartial, (BlockState)blockState).light(light);
                SpriteShiftEntry spriteShift = TieredBeltRenderer.getSpriteShiftEntry(tbb, diagonal, bottom);
                SpriteShiftEntry overlayShift = TieredBeltRenderer.getDyeOverlayEntry(tbb, color, diagonal);
                float speed = be.getSpeed();
                if (speed != 0.0f || be.color.isPresent()) {
                    float time = renderTick * (float)axisDirection.m_122540_();
                    if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == Direction.AxisDirection.NEGATIVE) {
                        speed = -speed;
                    }
                    float scrollMult = diagonal ? 0.375f : 0.5f;
                    float spriteSize = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMult;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                    overlayBuffer.shiftUVScrolling(overlayShift, (float)scroll);
                }
                ((SuperByteBuffer)beltBuffer.transform(localTransforms)).renderInto(ms, vb);
                ((SuperByteBuffer)overlayBuffer.transform(localTransforms)).renderInto(ms, vb);
                if (diagonal) break;
            }
            if (be.hasPulley()) {
                Direction dir = sideways ? Direction.UP : ((Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122427_();
                Supplier<PoseStack> matrixStackSupplier = () -> {
                    PoseStack stack = new PoseStack();
                    PoseTransformStack stacker = TransformStack.of((PoseStack)stack);
                    stacker.center();
                    if (dir.m_122434_() == Direction.Axis.X) {
                        stacker.rotateYDegrees(90.0f);
                    }
                    if (dir.m_122434_() == Direction.Axis.Y) {
                        stacker.rotateXDegrees(90.0f);
                    }
                    stacker.rotateXDegrees(90.0f);
                    stacker.uncenter();
                    return stack;
                };
                SuperByteBuffer superBuffer = CachedBuffers.partialDirectional((PartialModel)this.getBeltPulleyModel(blockState), (BlockState)blockState, (Direction)dir, matrixStackSupplier);
                KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
            }
        }
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(TieredBeltBlock block, boolean diagonal, boolean bottom) {
        return diagonal ? GreateSpriteShifts.BELT_SPRITES.get(block).get(2) : (bottom ? GreateSpriteShifts.BELT_SPRITES.get(block).get(1) : GreateSpriteShifts.BELT_SPRITES.get(block).get(0));
    }

    public static SpriteShiftEntry getDyeOverlayEntry(TieredBeltBlock block, DyeColor color, boolean diagonal) {
        if (color != null) {
            return diagonal ? GreateSpriteShifts.DYED_DIAGONAL_BELTS.get(block).get(color) : GreateSpriteShifts.DYED_BELTS.get(block).get(color);
        }
        return GreateSpriteShifts.BELT_SPRITES.get(block).get(3);
    }

    public static PartialModel getBeltPartial(TieredBeltBlock block, boolean diagonal, boolean start, boolean end, boolean bottom) {
        Material beltMaterial = block.getBeltMaterial();
        if (diagonal) {
            if (start) {
                return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(8);
            }
            if (end) {
                return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(10);
            }
            return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(9);
        }
        if (bottom) {
            if (start) {
                return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(5);
            }
            if (end) {
                return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(7);
            }
            return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(6);
        }
        if (start) {
            return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(2);
        }
        if (end) {
            return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(4);
        }
        return GreatePartialModels.NEW_BELT_MODELS.get(beltMaterial).get(3);
    }

    public static PartialModel getOverlayPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return GreatePartialModels.BELT_OVERLAY_DIAGONAL_START;
            }
            if (end) {
                return GreatePartialModels.BELT_OVERLAY_DIAGONAL_END;
            }
            return GreatePartialModels.BELT_OVERLAY_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return GreatePartialModels.BELT_OVERLAY_START_BOTTOM;
            }
            if (end) {
                return GreatePartialModels.BELT_OVERLAY_END_BOTTOM;
            }
            return GreatePartialModels.BELT_OVERLAY_MIDDLE_BOTTOM;
        }
        if (start) {
            return GreatePartialModels.BELT_OVERLAY_START;
        }
        if (end) {
            return GreatePartialModels.BELT_OVERLAY_END;
        }
        return GreatePartialModels.BELT_OVERLAY_MIDDLE;
    }
}

