/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.crusher;

import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import electrolyte.greate.content.kinetics.crusher.TieredCrushingWheelControllerBlock;
import electrolyte.greate.foundation.data.recipe.TieredRecipeConditions;
import electrolyte.greate.foundation.recipe.TieredRecipeFinder;
import electrolyte.greate.foundation.recipe.TieredRecipeHelper;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TieredCrushingWheelControllerBlockEntity
extends CrushingWheelControllerBlockEntity {
    private final RecipeWrapper wrapper;
    private static final Object CRUSHING_RECIPES_CACHE_KEY = new Object();
    private int tier;

    public TieredCrushingWheelControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::itemInserted){

            public boolean isItemValid(int slot, ItemStack stack) {
                return super.isItemValid(slot, stack) && TieredCrushingWheelControllerBlockEntity.this.processingEntity == null;
            }
        };
        this.wrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
        this.tier = ((TieredCrushingWheelControllerBlock)state.m_60734_()).getTier();
    }

    private Optional<Recipe<?>> findValidRecipe() {
        return TieredRecipeFinder.findRecipe(CRUSHING_RECIPES_CACHE_KEY, this.f_58857_, this.wrapper, RecipeConditions.isOfType((RecipeType[])new RecipeType[]{ModRecipeTypes.CRUSHING.getType(), ModRecipeTypes.MILLING.getType()}).and(TieredRecipeConditions.firstIngredientMatches(this.wrapper.m_8020_(0))), TieredRecipeConditions.isEqualOrAboveTier(this.tier));
    }

    public void applyValidRecipe() {
        Optional<Recipe<?>> recipe = this.findValidRecipe();
        ArrayList list = new ArrayList();
        if (recipe.isPresent()) {
            int rolls = this.inventory.getStackInSlot(0).m_41613_();
            this.inventory.clear();
            for (int roll = 0; roll < rolls; ++roll) {
                List<ItemStack> rolledResults = TieredRecipeHelper.INSTANCE.getItemResults(recipe.get(), this.tier);
                for (ItemStack stack : rolledResults) {
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
        } else {
            this.inventory.clear();
        }
    }

    private void itemInserted(ItemStack stack) {
        Recipe<?> recipe;
        Optional<Recipe<?>> recipe2 = this.findValidRecipe();
        int remainingTime = 100;
        if (recipe2.isPresent() && (recipe = recipe2.get()) instanceof ProcessingRecipe) {
            ProcessingRecipe pr = (ProcessingRecipe)recipe;
            remainingTime = pr.getProcessingDuration();
        }
        this.inventory.remainingTime = remainingTime;
        this.inventory.appliedRecipe = false;
    }
}

