/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.fan;

import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.AirCurrentSound;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import electrolyte.greate.content.kinetics.fan.TieredFanProcessing;
import java.util.Iterator;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class TieredAirCurrent
extends AirCurrent {
    int machineTier;
    @OnlyIn(value=Dist.CLIENT)
    private static AirCurrentSound flyingSound;
    private static boolean isClientPlayerInAirCurrent;

    public TieredAirCurrent(IAirCurrentSource source, int tier) {
        super(source);
        this.machineTier = tier;
    }

    public void tickAffectedHandlers() {
        for (Pair pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            Level level = handler.getWorld();
            FanProcessingType processingType = (FanProcessingType)pair.getRight();
            if (processingType == null) continue;
            handler.handleProcessingOnAllItems(transported -> {
                IAirCurrentSource patt2434$temp;
                if (level.f_46443_) {
                    processingType.spawnProcessingParticles(level, handler.getWorldPositionOf(transported));
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = TieredFanProcessing.applyProcessing(this.source.getSpeed(), transported, level, processingType, this.machineTier);
                if (!applyProcessing.doesNothing() && (patt2434$temp = this.source) instanceof EncasedFanBlockEntity) {
                    EncasedFanBlockEntity fan = (EncasedFanBlockEntity)patt2434$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    protected void tickAffectedEntities(Level level) {
        Iterator iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            FanProcessingType processingType;
            Entity entity = (Entity)iterator.next();
            if (!entity.m_6084_() || !entity.m_20191_().m_82381_(this.bounds) || TieredAirCurrent.isPlayerCreativeFlying((Entity)entity)) {
                iterator.remove();
                continue;
            }
            Vec3i flow = (this.pushing ? this.direction : this.direction.m_122424_()).m_122436_();
            float speed = Math.abs(this.source.getSpeed());
            float sneakModifier = entity.m_6144_() ? 4096.0f : 512.0f;
            double entityDistance = VecHelper.alignedDistanceToFace((Vec3)entity.m_20182_(), (BlockPos)this.source.getAirCurrentPos(), (Direction)this.direction);
            double entityDistanceOld = entity.m_20182_().m_82554_(VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()));
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistanceOld / (double)this.maxDistance));
            Vec3 previousMotion = entity.m_20184_();
            float maxAcceleration = 5.0f;
            double xIn = Mth.m_14008_((double)((double)((float)flow.m_123341_() * acceleration) - previousMotion.f_82479_), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.m_14008_((double)((double)((float)flow.m_123342_() * acceleration) - previousMotion.f_82480_), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.m_14008_((double)((double)((float)flow.m_123343_() * acceleration) - previousMotion.f_82481_), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.m_20256_(previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125)));
            entity.f_19789_ = 0.0f;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TieredAirCurrent.enableClientPlayerSound(entity, Mth.m_14036_((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity;
                sp.f_8906_.f_9737_ = 0;
            }
            if ((processingType = this.getTypeAt((float)entityDistance)) == null) continue;
            if (entity instanceof ItemEntity) {
                IAirCurrentSource iAirCurrentSource;
                ItemEntity itemEntity = (ItemEntity)entity;
                if (level != null && level.f_46443_) {
                    processingType.spawnProcessingParticles(level, entity.m_20182_());
                    continue;
                }
                if (!TieredFanProcessing.canProcess(itemEntity, processingType, this.machineTier) || !TieredFanProcessing.applyProcessing(this.source.getSpeed(), itemEntity, processingType, this.machineTier) || !((iAirCurrentSource = this.source) instanceof EncasedFanBlockEntity)) continue;
                EncasedFanBlockEntity fan = (EncasedFanBlockEntity)iAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            if (level == null) continue;
            processingType.affectEntity(entity, level);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enableClientPlayerSound(Entity e, float maxVolume) {
        if (e != Minecraft.m_91087_().m_91288_()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)Mth.m_14008_((double)(e.m_20184_().m_82553_() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.m_7801_()) {
            flyingSound = new TieredAirCurrentSound(SoundEvents.f_11886_, pitch);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    private static class TieredAirCurrentSound
    extends AirCurrentSound {
        protected TieredAirCurrentSound(SoundEvent p_i46532_1_, float pitch) {
            super(p_i46532_1_, pitch);
        }
    }
}

