/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.fan;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.content.kinetics.fan.TieredEncasedFanBlock;
import electrolyte.greate.content.kinetics.fan.TieredEncasedFanBlockEntity;
import electrolyte.greate.registry.GreatePartialModels;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TieredEncasedFanVisual
extends KineticBlockEntityVisual<TieredEncasedFanBlockEntity> {
    protected final RotatingInstance halfShaft;
    protected final RotatingInstance fanInner;
    private final Direction dir;
    private final Direction opposite;

    public TieredEncasedFanVisual(VisualizationContext context, TieredEncasedFanBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.dir = (Direction)this.blockState.m_61143_((Property)EncasedFanBlock.FACING);
        this.opposite = this.dir.m_122424_();
        int tier = ((TieredEncasedFanBlock)this.blockState.m_60734_()).getTier();
        this.halfShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)GreatePartialModels.SHAFT_HALF_MODELS[tier])).createInstance();
        this.fanInner = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)GreatePartialModels.FAN_INNER_MODELS[tier])).createInstance();
        this.halfShaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.fanInner.setup((KineticBlockEntity)blockEntity, this.getFanSpeed()).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
    }

    private float getFanSpeed() {
        float speed = ((TieredEncasedFanBlockEntity)this.blockEntity).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    public void update(float partialTick) {
        this.halfShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        this.fanInner.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos.m_121945_(this.opposite), new FlatLit[]{this.halfShaft});
        this.relight(this.pos.m_121945_(this.dir), new FlatLit[]{this.fanInner});
    }

    protected void _delete() {
        this.halfShaft.delete();
        this.fanInner.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.halfShaft);
        consumer.accept((Instance)this.fanInner);
    }
}

