/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.millstone;

import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import electrolyte.greate.content.kinetics.millstone.TieredMillingRecipe;
import electrolyte.greate.content.kinetics.millstone.TieredMillstoneBlock;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import electrolyte.greate.foundation.data.recipe.TieredRecipeConditions;
import electrolyte.greate.foundation.recipe.TieredRecipeFinder;
import electrolyte.greate.foundation.recipe.TieredRecipeHelper;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TieredMillstoneBlockEntity
extends MillstoneBlockEntity
implements ITieredKineticBlockEntity {
    private TieredMillingRecipe lastRecipe;
    private int tier;
    private static final Object MILLING_RECIPE_CACHE_KEY = new Object();

    public TieredMillstoneBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.tier = ((TieredMillstoneBlock)state.m_60734_()).getTier();
    }

    public void setupRecipe() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional<Recipe<?>> recipe = this.findRecipe(inventoryIn);
            if (recipe.isEmpty()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (TieredMillingRecipe)recipe.get();
                this.timer = ((TieredMillingRecipe)recipe.get()).getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    public void processRecipe() {
        if (this.inputInv.getStackInSlot(0).m_41619_()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            Optional<Recipe<?>> recipe = this.findRecipe(inventoryIn);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (TieredMillingRecipe)recipe.get();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.m_41774_(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        List<ItemStack> results = TieredRecipeHelper.INSTANCE.getItemResults((Recipe<?>)this.lastRecipe, this.tier);
        results.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)stack, (boolean)false));
        this.award(AllAdvancements.MILLSTONE);
        this.sendData();
        this.m_6596_();
    }

    public boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && TieredRecipeFinder.shouldRefreshRecipe()) {
            this.lastRecipe = null;
        }
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            return true;
        }
        return this.findRecipe(inventoryIn).isPresent();
    }

    public Optional<Recipe<?>> findRecipe(RecipeWrapper wrapper) {
        return TieredRecipeFinder.findRecipe(MILLING_RECIPE_CACHE_KEY, this.f_58857_, wrapper, RecipeConditions.isOfType((RecipeType[])new RecipeType[]{ModRecipeTypes.MILLING.getType()}).and(TieredRecipeConditions.firstIngredientMatches(wrapper.m_8020_(0))), TieredRecipeConditions.isEqualOrAboveTier(this.tier));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return ITieredKineticBlockEntity.super.addToGoggleTooltip(tooltip, isPlayerSneaking, this.tier, this.capacity, this.stress);
    }
}

