/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.mixer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.content.kinetics.mixer.TieredMechanicalMixerBlock;
import electrolyte.greate.content.kinetics.mixer.TieredMechanicalMixerBlockEntity;
import electrolyte.greate.registry.GreatePartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TieredMechanicalMixerRenderer
extends KineticBlockEntityRenderer<TieredMechanicalMixerBlockEntity> {
    public TieredMechanicalMixerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(TieredMechanicalMixerBlockEntity pBlockEntity) {
        return true;
    }

    protected void renderSafe(TieredMechanicalMixerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        BlockState blockState = be.m_58900_();
        TieredMechanicalMixerBlock mixerBlock = (TieredMechanicalMixerBlock)blockState.m_60734_();
        int tier = mixerBlock.getTier();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer byteBuffer = CachedBuffers.partial((PartialModel)GreatePartialModels.COGWHEEL_SHAFTLESS_MODELS[tier], (BlockState)blockState);
        TieredMechanicalMixerRenderer.standardKineticRotationTransform((SuperByteBuffer)byteBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
        float renderedHeadOffset = be.getRenderedHeadOffset(partialTicks);
        float speed = be.getRenderedHeadRotationSpeed(partialTicks);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float angle = time * speed * 6.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer poleRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE, (BlockState)blockState);
        ((SuperByteBuffer)poleRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vb);
        VertexConsumer vbConsumer = buffer.m_6299_(RenderType.m_110457_());
        SuperByteBuffer headRender = CachedBuffers.partial((PartialModel)GreatePartialModels.MECHANICAL_MIXER_HEAD_MODELS[tier], (BlockState)blockState);
        ((SuperByteBuffer)((SuperByteBuffer)headRender.rotateCentered(angle, Direction.UP)).translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vbConsumer);
    }
}

