/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.mixer;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import electrolyte.greate.content.kinetics.mixer.TieredMechanicalMixerBlockEntity;
import electrolyte.greate.registry.GreatePartialModels;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class TieredMechanicalMixerVisual
extends SingleAxisRotatingVisual<TieredMechanicalMixerBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance mixerHead;
    private final OrientedInstance mixerPole;
    private final TieredMechanicalMixerBlockEntity mixer;

    public TieredMechanicalMixerVisual(VisualizationContext context, TieredMechanicalMixerBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)GreatePartialModels.COGWHEEL_SHAFTLESS_MODELS[blockEntity.getTier()]));
        this.mixer = blockEntity;
        this.mixerHead = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)GreatePartialModels.MECHANICAL_MIXER_HEAD_MODELS[blockEntity.getTier()])).createInstance();
        this.mixerHead.setRotationAxis(Direction.Axis.Y);
        this.mixerPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE)).createInstance();
        this.animate(partialTick);
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.animate(context.partialTick());
    }

    private void animate(float partialTick) {
        float renderedHeadOffset = this.mixer.getRenderedHeadOffset(partialTick);
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset, partialTick);
    }

    private void transformHead(float renderedHeadOffset, float partialTick) {
        float speed = this.mixer.getRenderedHeadRotationSpeed(partialTick);
        this.mixerHead.setPosition((Vec3i)this.getVisualPosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f).setChanged();
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pos.m_7495_(), new FlatLit[]{this.mixerHead});
        this.relight(new FlatLit[]{this.mixerPole});
    }

    protected void _delete() {
        super._delete();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.mixerHead);
        consumer.accept((Instance)this.mixerPole);
    }
}

