/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.press;

import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import electrolyte.greate.content.kinetics.base.TieredShaftVisual;
import electrolyte.greate.content.kinetics.press.TieredMechanicalPressBlockEntity;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.registry.GreatePartialModels;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TieredMechanicalPressVisual
extends TieredShaftVisual<TieredMechanicalPressBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance pressHead;

    public TieredMechanicalPressVisual(VisualizationContext context, TieredMechanicalPressBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        int tier = ((ITieredBlock)blockEntity.m_58900_().m_60734_()).getTier();
        this.pressHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)GreatePartialModels.MECHANICAL_PRESS_HEAD_MODELS[tier])).createInstance();
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING))));
        this.pressHead.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.transformModels(context.partialTick());
    }

    private void transformModels(float partialTick) {
        float renderedHeadOffset = this.getRenderedHeadOffset(partialTick);
        this.pressHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float partialTick) {
        PressingBehaviour pressingBehaviour = ((TieredMechanicalPressBlockEntity)this.blockEntity).getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(partialTick) * pressingBehaviour.mode.headOffset;
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.pressHead});
    }

    protected void _delete() {
        super._delete();
        this.pressHead.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.pressHead);
    }
}

