/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.saw;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.kinetics.saw.TieredSawBlock;
import electrolyte.greate.content.kinetics.saw.TieredSawBlockEntity;
import electrolyte.greate.registry.GreatePartialModels;
import electrolyte.greate.registry.GreateTagPrefixes;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class TieredSawRenderer
extends SawRenderer {
    private int tier;

    public TieredSawRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SawBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        this.tier = ((TieredSawBlock)be.m_58900_().m_60734_()).getTier();
        this.renderBlade(be, ms, bufferSource, light);
        this.renderItems(be, partialTicks, ms, bufferSource, light, overlay);
        if (be.m_58900_().m_61143_((Property)SawBlock.FACING) == Direction.UP) {
            this.renderFluid((TieredSawBlockEntity)be, partialTicks, ms, bufferSource, light);
        }
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)bufferSource, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        this.renderShaft(be, ms, bufferSource, light, overlay);
    }

    protected void renderBlade(SawBlockEntity be, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        PartialModel sawModel;
        BlockState state = be.m_58900_();
        float speed = be.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal((BlockState)state)) {
            sawModel = speed > 0.0f ? GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_ACTIVE_MODELS[this.tier] : (speed < 0.0f ? GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_REVERSED_MODELS[this.tier] : GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_INACTIVE_MODELS[this.tier]);
        } else {
            sawModel = speed > 0.0f ? GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_ACTIVE_MODELS[this.tier] : (speed < 0.0f ? GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_REVERSED_MODELS[this.tier] : GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_INACTIVE_MODELS[this.tier]);
            if (((Boolean)state.m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)sawModel, (BlockState)state);
        if (rotate) {
            superByteBuffer.rotateCentered(AngleHelper.rad((double)90.0), Direction.UP);
        }
        superByteBuffer.color(0xFFFFFF).light(light).renderInto(poseStack, bufferSource.m_6299_(RenderType.m_110457_()));
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        BlockState state = be.m_58900_();
        if (((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_().m_122479_()) {
            return CachedBuffers.partialFacing((PartialModel)GreatePartialModels.SHAFT_HALF_MODELS[this.tier], (BlockState)state.rotate((LevelAccessor)be.m_58904_(), be.m_58899_(), Rotation.CLOCKWISE_180));
        }
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return (BlockState)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.shaft, (Material)GreateValues.TM[this.tier]).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource bufferSource) {
        SuperByteBuffer superBuffer;
        SuperByteBuffer buffer;
        BlockState state = context.state;
        Direction facing = (Direction)state.m_61143_((Property)SawBlock.FACING);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)SawBlock.FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        boolean horizontal = closestToFacing.m_122434_().m_122479_();
        boolean backwards = VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.m_122424_());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        int tier = ((TieredSawBlock)state.m_60734_()).getTier();
        if (SawBlock.isHorizontal((BlockState)state)) {
            buffer = CachedBuffers.partial((PartialModel)GreatePartialModels.SHAFT_HALF_MODELS[tier], (BlockState)state);
            superBuffer = shouldAnimate ? CachedBuffers.partial((PartialModel)GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_ACTIVE_MODELS[tier], (BlockState)state) : CachedBuffers.partial((PartialModel)GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_INACTIVE_MODELS[tier], (BlockState)state);
        } else {
            buffer = CachedBuffers.partial((PartialModel)GreatePartialModels.SHAFT_MODELS[tier], (BlockState)state);
            superBuffer = shouldAnimate ? CachedBuffers.partial((PartialModel)GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_ACTIVE_MODELS[tier], (BlockState)state) : CachedBuffers.partial((PartialModel)GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_INACTIVE_MODELS[tier], (BlockState)state);
        }
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing.m_122424_()))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing.m_122424_()));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing));
        if (!SawBlock.isHorizontal((BlockState)state)) {
            buffer.rotateZDegrees((Boolean)state.m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0f : 0.0f);
            superBuffer.rotateZDegrees((Boolean)state.m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0f : 0.0f);
        }
        if (!VisualizationManager.supportsVisualization((LevelAccessor)renderWorld)) {
            ((SuperByteBuffer)buffer.uncenter()).light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), bufferSource.m_6299_(RenderType.m_110451_()));
        }
        ((SuperByteBuffer)superBuffer.uncenter()).light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), bufferSource.m_6299_(RenderType.m_110457_()));
    }

    private void renderFluid(TieredSawBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        SmartFluidTankBehaviour behaviour = (SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.INPUT);
        if (behaviour == null) {
            return;
        }
        float units = behaviour.getTanks()[0].getTotalUnits(partialTicks);
        if (units < 1.0f) {
            return;
        }
        float xMin = 0.4375f;
        float xMax = 0.5625f;
        float yMin = 0.8125f;
        float yMax = 0.813125f;
        float zMin = 0.125f;
        float zMax = 0.875f;
        FluidStack renderedFluid = behaviour.getTanks()[0].getRenderedFluid();
        if (renderedFluid.isEmpty()) {
            return;
        }
        if (((Boolean)be.m_58900_().m_61143_((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
            ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)renderedFluid, 0.4375f, 0.8125f, 0.125f, 0.5625f, 0.813125f, 0.875f, bufferSource, poseStack, light, false, false);
        } else {
            ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)renderedFluid, 0.125f, 0.8125f, 0.4375f, 0.875f, 0.813125f, 0.5625f, bufferSource, poseStack, light, false, false);
        }
    }
}

