/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.kinetics.simpleRelays.encased;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.registry.GreatePartialModels;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TieredEncasedCogVisual
extends KineticBlockEntityVisual<KineticBlockEntity> {
    private final boolean large;
    protected RotatingInstance rotatingModel;
    @Nullable
    protected final RotatingInstance rotatingTopShaft;
    @Nullable
    protected final RotatingInstance rotatingBottomShaft;
    protected int tier;

    public static TieredEncasedCogVisual small(VisualizationContext context, KineticBlockEntity be, float partialTick) {
        return new TieredEncasedCogVisual(context, be, false, partialTick);
    }

    public static TieredEncasedCogVisual large(VisualizationContext context, KineticBlockEntity be, float partialTick) {
        return new TieredEncasedCogVisual(context, be, true, partialTick);
    }

    public TieredEncasedCogVisual(VisualizationContext context, KineticBlockEntity blockEntity, boolean large, float partialTick) {
        super(context, blockEntity, partialTick);
        this.large = large;
        this.tier = ((ITieredBlock)this.blockState.m_60734_()).getTier();
        this.rotatingModel = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, this.getCogModel()).createInstance();
        this.rotatingModel.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(this.rotationAxis()).setChanged();
        RotatingInstance rotatingTopShaft = null;
        RotatingInstance rotatingBottomShaft = null;
        Block block = this.blockState.m_60734_();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.rotationAxis())) {
                if (!def.hasShaftTowards((LevelReader)blockEntity.m_58904_(), blockEntity.m_58899_(), this.blockState, d)) continue;
                RotatingInstance data = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)GreatePartialModels.SHAFT_HALF_MODELS[this.tier])).createInstance();
                data.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, d).setChanged();
                if (large) {
                    data.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos));
                }
                if (d.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    rotatingTopShaft = data;
                    continue;
                }
                rotatingBottomShaft = data;
            }
        }
        this.rotatingTopShaft = rotatingTopShaft;
        this.rotatingBottomShaft = rotatingBottomShaft;
    }

    public void update(float partialTick) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.rotatingModel, this.rotatingTopShaft, this.rotatingBottomShaft});
    }

    protected void _delete() {
        this.rotatingModel.delete();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.delete();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.delete();
        }
    }

    protected Model getCogModel() {
        PartialModel cogModel = this.large ? GreatePartialModels.LARGE_COGWHEEL_SHAFTLESS_MODELS[this.tier] : GreatePartialModels.COGWHEEL_SHAFTLESS_MODELS[this.tier];
        return Models.partial((PartialModel)cogModel);
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.rotatingModel);
        consumer.accept((Instance)this.rotatingTopShaft);
        consumer.accept((Instance)this.rotatingBottomShaft);
    }
}

