/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.processing.basin;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import electrolyte.greate.content.kinetics.base.ICircuitHolder;
import electrolyte.greate.content.kinetics.mixer.TieredBrewingRecipe;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredBlock;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import electrolyte.greate.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TieredBasinRecipe
extends TieredProcessingRecipe<Container> {
    public TieredBasinRecipe(TieredProcessingRecipeBuilder.TieredProcessingRecipeParams params) {
        this(ModRecipeTypes.BASIN, params);
    }

    protected TieredBasinRecipe(IRecipeTypeInfo typeInfo, TieredProcessingRecipeBuilder.TieredProcessingRecipeParams params) {
        super(typeInfo, params);
    }

    public static boolean match(BasinBlockEntity basin, Recipe<?> recipe, int machineTier) {
        FilteringBehaviour filter = basin.getFilter();
        int recipeTier = 0;
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(basin.m_58904_().m_9598_()));
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe basinRecipe = (ProcessingRecipe)recipe;
            if (basinRecipe instanceof TieredProcessingRecipe) {
                TieredProcessingRecipe tpr = (TieredProcessingRecipe)basinRecipe;
                recipeTier = tpr.getRecipeTier();
            }
            if (basinRecipe.getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
                filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
            }
        }
        if (!filterTest) {
            return false;
        }
        if (machineTier < recipeTier) {
            return false;
        }
        return TieredBasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(BasinBlockEntity basin, Recipe<?> recipe) {
        return TieredBasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(BasinBlockEntity basin, Recipe<?> recipe, boolean test) {
        ITieredBlock tieredBlock;
        Block block;
        if (recipe instanceof BasinRecipe) {
            return false;
        }
        if (!((Boolean)AllConfigs.server().recipes.allowBrewingInMixer.get()).booleanValue() && recipe instanceof TieredBrewingRecipe) {
            return false;
        }
        boolean isTieredBasinRecipe = recipe instanceof TieredBasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isTieredBasinRecipe && !((ProcessingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        if (isTieredBasinRecipe && (block = basin.m_58904_().m_8055_(basin.m_58899_().m_6630_(2)).m_60734_()) instanceof ITieredBlock && (tieredBlock = (ITieredBlock)block).getTier() < ((TieredBasinRecipe)recipe).getRecipeTier()) {
            return false;
        }
        if (isTieredBasinRecipe && (block = basin.m_58904_().m_7702_(basin.m_58899_().m_6630_(2))) instanceof ICircuitHolder) {
            ICircuitHolder circuitHolder = (ICircuitHolder)block;
            if (((TieredBasinRecipe)recipe).getCircuitNumber() != -1 && circuitHolder.getCircuitNumber() != ((TieredBasinRecipe)recipe).getCircuitNumber()) {
                return false;
            }
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        NonNullList fluidIngredients = isTieredBasinRecipe ? ((ProcessingRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        for (boolean simulate : Iterate.trueAndFalse) {
            Object ingredient2;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Object ingredient2 : ingredients) {
                int amountRequired = ingredient2.m_43908_()[0].m_41613_();
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient2.test(extracted = availableItems.extractItem(slot, amountRequired, true))) continue;
                    int removedAmount = Math.min(amountRequired, availableItems.getStackInSlot(slot).m_41613_());
                    if (!simulate) {
                        availableItems.extractItem(slot, amountRequired, false);
                    }
                    if ((amountRequired -= removedAmount) != 0) continue;
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            ingredient2 = fluidIngredients.iterator();
            block3: while (ingredient2.hasNext()) {
                FluidIngredient fluidIngredient = (FluidIngredient)ingredient2.next();
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                DummyCraftingContainer remainderContainer = new DummyCraftingContainer(availableItems, extractedItemsFromSlot);
                if (recipe instanceof TieredBasinRecipe) {
                    TieredBasinRecipe basinRecipe = (TieredBasinRecipe)recipe;
                    recipeOutputItems.addAll(basinRecipe.rollResults());
                    for (FluidStack stack : basinRecipe.getFluidResults()) {
                        if (stack.isEmpty()) continue;
                        recipeOutputFluids.add(stack);
                    }
                    for (ItemStack stack : basinRecipe.m_7457_((Container)remainderContainer)) {
                        if (stack.m_41619_()) continue;
                        recipeOutputItems.add(stack);
                    }
                } else if (recipe instanceof BasinRecipe) {
                    BasinRecipe basinRecipe = (BasinRecipe)recipe;
                    recipeOutputItems.addAll(basinRecipe.rollResults());
                    for (FluidStack stack : basinRecipe.getFluidResults()) {
                        if (stack.isEmpty()) continue;
                        recipeOutputFluids.add(stack);
                    }
                    for (ItemStack stack : basinRecipe.m_7457_((Container)remainderContainer)) {
                        if (stack.m_41619_()) continue;
                        recipeOutputItems.add(stack);
                    }
                } else {
                    recipeOutputItems.add(recipe.m_8043_(basin.m_58904_().m_9598_()));
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        for (ItemStack stack : craftingRecipe.m_7457_((Container)remainderContainer)) {
                            if (stack.m_41619_()) continue;
                            recipeOutputItems.add(stack);
                        }
                    }
                }
            }
            if (basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public static TieredBasinRecipe convertShapeless(Recipe<?> recipe) {
        return new TieredProcessingRecipeBuilder<TieredBasinRecipe>(TieredBasinRecipe::new, recipe.m_6423_()).withItemIngredients((NonNullList<Ingredient>)recipe.m_7527_()).withSingleItemOutput(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())).build();
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }
}

