/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.processing.recipe;

import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import electrolyte.greate.Greate;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.slf4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TieredProcessingRecipe<T extends Container>
extends ProcessingRecipe<T> {
    protected int recipeTier;
    protected int circuitNumber;

    public TieredProcessingRecipe(IRecipeTypeInfo typeInfo, TieredProcessingRecipeBuilder.TieredProcessingRecipeParams params) {
        super(typeInfo, (ProcessingRecipeBuilder.ProcessingRecipeParams)params);
        this.processingDuration = params.processingDuration;
        this.fluidIngredients = params.fluidIngredients;
        this.fluidResults = params.fluidResults;
        this.requiredHeat = params.requiredHeat;
        this.ingredients = params.ingredients;
        this.results = params.results;
        this.recipeTier = params.recipeTier;
        this.circuitNumber = params.circuitNumber;
        this.id = params.id;
        this.validate(typeInfo.getId());
    }

    private void validate(ResourceLocation recipeTypeId) {
        String messageHeader = "Your custom " + String.valueOf(recipeTypeId) + " recipe (" + this.id.toString() + ")";
        Logger logger = Greate.LOGGER;
        int ingredientCount = this.ingredients.size();
        int outputCount = this.results.size();
        if (ingredientCount > this.getMaxInputCount()) {
            logger.warn(messageHeader + " has more item inputs (" + ingredientCount + ") than supported (" + this.getMaxInputCount() + ").");
        }
        if (outputCount > this.getMaxOutputCount()) {
            logger.warn(messageHeader + " has more item outputs (" + outputCount + ") than supported (" + this.getMaxOutputCount() + ").");
        }
        if (this.processingDuration > 0 && !this.canSpecifyDuration()) {
            logger.warn(messageHeader + " specified a duration. Durations have no impact on this type of recipe.");
        }
        if (this.requiredHeat != HeatCondition.NONE && !this.canRequireHeat()) {
            logger.warn(messageHeader + " specified a heat condition. Heat conditions have no impact on this type of recipe.");
        }
        ingredientCount = this.fluidIngredients.size();
        outputCount = this.fluidResults.size();
        if (ingredientCount > this.getMaxFluidInputCount()) {
            logger.warn(messageHeader + " has more fluid inputs (" + ingredientCount + ") than supported (" + this.getMaxFluidInputCount() + ").");
        }
        if (outputCount > this.getMaxFluidOutputCount()) {
            logger.warn(messageHeader + " has more fluid outputs (" + outputCount + ") than supported (" + this.getMaxFluidOutputCount() + ").");
        }
    }

    public NonNullList<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public int getRecipeTier() {
        return this.recipeTier;
    }

    public int getCircuitNumber() {
        return this.circuitNumber;
    }

    public static int getCircuitFromGTRecipe(List<Content> inputContents) {
        int circuitNumber = -1;
        for (Content c : inputContents) {
            if (((Ingredient)c.getContent()).m_43908_().length == 0 || !((Ingredient)c.getContent()).m_43908_()[0].m_150930_(GTItems.PROGRAMMED_CIRCUIT.m_5456_())) continue;
            ItemStack circuit = ((Ingredient)c.getContent()).m_43908_()[0];
            circuitNumber = IntCircuitBehaviour.getCircuitConfiguration((ItemStack)circuit);
            break;
        }
        return circuitNumber;
    }
}

