/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.processing.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.DataIngredient;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Pair;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.fluids.FluidStack;

public class TieredProcessingRecipeBuilder<T extends TieredProcessingRecipe<?>> {
    protected TieredProcessingRecipeFactory<T> factory;
    protected TieredProcessingRecipeParams params;
    protected List<ICondition> recipeConditions;

    public TieredProcessingRecipeBuilder(TieredProcessingRecipeFactory<T> factory, ResourceLocation recipeId) {
        this.params = new TieredProcessingRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
        this.factory = factory;
    }

    public TieredProcessingRecipeBuilder<T> withItemIngredients(Ingredient ... ingredients) {
        return this.withItemIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public TieredProcessingRecipeBuilder<T> withItemIngredients(NonNullList<Ingredient> ingredients) {
        this.params.ingredients = ingredients;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> withItemIngredientsGT(List<Content> ingredients) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (Content c : ingredients) {
            SizedIngredient sizedIng;
            Ingredient ingredient = (Ingredient)c.getContent();
            if (ingredient instanceof SizedIngredient && (sizedIng = (SizedIngredient)ingredient).getInner() instanceof IntCircuitIngredient || c.getContent() instanceof IntCircuitIngredient) continue;
            nonNullList.add((Object)((Ingredient)c.getContent()));
        }
        return this.withItemIngredients((NonNullList<Ingredient>)nonNullList);
    }

    public TieredProcessingRecipeBuilder<T> withSingleItemOutput(ItemStack output) {
        return this.withItemOutputs(new ProcessingOutput(output, 1.0f));
    }

    public TieredProcessingRecipeBuilder<T> withItemOutputs(ProcessingOutput ... outputs) {
        return this.withItemOutputs((NonNullList<ProcessingOutput>)NonNullList.m_122783_((Object)ProcessingOutput.EMPTY, (Object[])outputs));
    }

    public TieredProcessingRecipeBuilder<T> withItemOutputs(NonNullList<ProcessingOutput> outputs) {
        this.params.results = outputs;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> withItemOutputs(List<ProcessingOutput> outputs) {
        NonNullList list = NonNullList.m_122779_();
        list.addAll(outputs);
        return this.withItemOutputs((NonNullList<ProcessingOutput>)list);
    }

    public TieredProcessingRecipeBuilder<T> withItemOutputsGT(List<Content> list) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (Content c : list) {
            ItemStack[] items;
            for (ItemStack item : items = ((Ingredient)c.content).m_43908_()) {
                nonNullList.add((Object)new ProcessingOutput(item, (float)c.chance / 10000.0f));
            }
        }
        return this.withItemOutputs((NonNullList<ProcessingOutput>)nonNullList);
    }

    public TieredProcessingRecipeBuilder<T> withFluidIngredients(com.simibubi.create.foundation.fluid.FluidIngredient ... ingredients) {
        return this.withFluidIngredients((NonNullList<com.simibubi.create.foundation.fluid.FluidIngredient>)NonNullList.m_122783_((Object)com.simibubi.create.foundation.fluid.FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public TieredProcessingRecipeBuilder<T> withFluidIngredients(NonNullList<com.simibubi.create.foundation.fluid.FluidIngredient> ingredients) {
        this.params.fluidIngredients = ingredients;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> withFluidIngredientsGT(List<Content> ingredients) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (Content c : ingredients) {
            FluidIngredient ingredient = (FluidIngredient)c.getContent();
            for (FluidIngredient.Value value : ingredient.values) {
                if (value instanceof FluidIngredient.TagValue) {
                    FluidIngredient.TagValue tag = (FluidIngredient.TagValue)value;
                    nonNullList.add((Object)com.simibubi.create.foundation.fluid.FluidIngredient.fromTag((TagKey)tag.tag(), (int)ingredient.getAmount()));
                    continue;
                }
                nonNullList.add((Object)com.simibubi.create.foundation.fluid.FluidIngredient.fromFluid((Fluid)ingredient.getStacks()[0].getFluid(), (int)ingredient.getAmount()));
            }
        }
        return this.withFluidIngredients((NonNullList<com.simibubi.create.foundation.fluid.FluidIngredient>)nonNullList);
    }

    public TieredProcessingRecipeBuilder<T> withFluidOutputs(FluidStack ... outputs) {
        return this.withFluidOutputs((NonNullList<FluidStack>)NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])outputs));
    }

    public TieredProcessingRecipeBuilder<T> withFluidOutputs(NonNullList<FluidStack> outputs) {
        this.params.fluidResults = outputs;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> withFluidOutputsGT(List<Content> list) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (Content c : list) {
            FluidStack[] fluids;
            for (FluidStack fluid : fluids = ((FluidIngredient)c.content).getStacks()) {
                nonNullList.add((Object)new FluidStack(fluid.getFluid(), fluid.getAmount()));
            }
        }
        return this.withFluidOutputs((NonNullList<FluidStack>)nonNullList);
    }

    public TieredProcessingRecipeBuilder<T> duration(int ticks) {
        this.params.processingDuration = ticks;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> averageProcessingDuration() {
        return this.duration(100);
    }

    public TieredProcessingRecipeBuilder<T> requiresHeat(HeatCondition condition) {
        this.params.requiredHeat = condition;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> recipeTier(int condition) {
        this.params.recipeTier = condition;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> recipeCircuit(int condition) {
        this.params.circuitNumber = condition;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> noCircuit() {
        this.params.circuitNumber = -1;
        return this;
    }

    public T build() {
        return this.factory.create(this.params);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult<T>(this.build(), this.recipeConditions));
    }

    public TieredProcessingRecipeBuilder<T> require(TagKey<Item> tag) {
        return this.require(Ingredient.m_204132_(tag));
    }

    public TieredProcessingRecipeBuilder<T> require(ItemLike item) {
        return this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public TieredProcessingRecipeBuilder<T> require(Ingredient ingredient) {
        this.params.ingredients.add((Object)ingredient);
        return this;
    }

    public TieredProcessingRecipeBuilder<T> require(Mods mod, String id) {
        this.params.ingredients.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public TieredProcessingRecipeBuilder<T> require(ResourceLocation ingredient) {
        this.params.ingredients.add((Object)DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]));
        return this;
    }

    public TieredProcessingRecipeBuilder<T> require(Fluid fluid, int amount) {
        return this.require(com.simibubi.create.foundation.fluid.FluidIngredient.fromFluid((Fluid)fluid, (int)amount));
    }

    public TieredProcessingRecipeBuilder<T> require(TagKey<Fluid> fluidTag, int amount) {
        return this.require(com.simibubi.create.foundation.fluid.FluidIngredient.fromTag(fluidTag, (int)amount));
    }

    public TieredProcessingRecipeBuilder<T> require(com.simibubi.create.foundation.fluid.FluidIngredient ingredient) {
        this.params.fluidIngredients.add((Object)ingredient);
        return this;
    }

    public TieredProcessingRecipeBuilder<T> output(ItemLike item) {
        return this.output(item, 1);
    }

    public TieredProcessingRecipeBuilder<T> output(float chance, ItemLike item) {
        return this.output(chance, item, 1);
    }

    public TieredProcessingRecipeBuilder<T> output(ItemLike item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public TieredProcessingRecipeBuilder<T> output(float chance, ItemLike item, int amount) {
        return this.output(chance, new ItemStack(item, amount));
    }

    public TieredProcessingRecipeBuilder<T> output(ItemStack output) {
        return this.output(1.0f, output);
    }

    public TieredProcessingRecipeBuilder<T> output(float chance, ItemStack output) {
        return this.output(new ProcessingOutput(output, chance));
    }

    public TieredProcessingRecipeBuilder<T> output(float chance, Mods mod, String id, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)mod.asResource(id), (Object)amount), chance));
    }

    public TieredProcessingRecipeBuilder<T> output(float chance, ResourceLocation registryName, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)registryName, (Object)amount), chance));
    }

    public TieredProcessingRecipeBuilder<T> output(ProcessingOutput output) {
        this.params.results.add((Object)output);
        return this;
    }

    public TieredProcessingRecipeBuilder<T> output(Fluid fluid, int amount) {
        fluid = FluidHelper.convertToStill((Fluid)fluid);
        return this.output(new FluidStack(fluid, amount));
    }

    public TieredProcessingRecipeBuilder<T> output(FluidStack fluidStack) {
        this.params.fluidResults.add((Object)fluidStack);
        return this;
    }

    public TieredProcessingRecipeBuilder<T> toolNotConsumed() {
        this.params.keepHeldItem = true;
        return this;
    }

    public TieredProcessingRecipeBuilder<T> whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public TieredProcessingRecipeBuilder<T> whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public TieredProcessingRecipeBuilder<T> withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public static class TieredProcessingRecipeParams
    extends ProcessingRecipeBuilder.ProcessingRecipeParams {
        protected ResourceLocation id;
        protected NonNullList<Ingredient> ingredients;
        protected NonNullList<ProcessingOutput> results;
        protected NonNullList<com.simibubi.create.foundation.fluid.FluidIngredient> fluidIngredients;
        protected NonNullList<FluidStack> fluidResults;
        protected int processingDuration;
        protected HeatCondition requiredHeat;
        protected int recipeTier;
        protected int circuitNumber;
        public boolean keepHeldItem;

        protected TieredProcessingRecipeParams(ResourceLocation id) {
            super(id);
            this.id = id;
            this.ingredients = NonNullList.m_122779_();
            this.results = NonNullList.m_122779_();
            this.fluidIngredients = NonNullList.m_122779_();
            this.fluidResults = NonNullList.m_122779_();
            this.processingDuration = 0;
            this.requiredHeat = HeatCondition.NONE;
            this.recipeTier = 0;
            this.circuitNumber = -1;
            this.keepHeldItem = false;
        }
    }

    @FunctionalInterface
    public static interface TieredProcessingRecipeFactory<T extends TieredProcessingRecipe<?>> {
        public T create(TieredProcessingRecipeParams var1);
    }

    public static class DataGenResult<S extends TieredProcessingRecipe<?>>
    implements FinishedRecipe {
        private List<ICondition> recipeConditions;
        private TieredProcessingRecipeSerializer<S> serializer;
        private ResourceLocation id;
        private S recipe;

        public DataGenResult(S recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = this.recipe.getTypeInfo();
            ResourceLocation typeId = recipeType.getId();
            if (!(recipeType.getSerializer() instanceof TieredProcessingRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen ProcessingRecipe of type: " + String.valueOf(typeId));
            }
            this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), typeId.m_135815_() + "/" + recipe.m_6423_().m_135815_());
            this.serializer = (TieredProcessingRecipeSerializer)recipe.m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

