/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.content.processing.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TieredProcessingRecipeSerializer<T extends TieredProcessingRecipe<?>>
implements RecipeSerializer<T> {
    private final TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<T> factory;

    public TieredProcessingRecipeSerializer(TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<T> factory) {
        this.factory = factory;
    }

    protected void writeToJson(JsonObject json, T recipe) {
        HeatCondition requiredHeat;
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        recipe.m_7527_().forEach(i -> jsonIngredients.add(i.m_43942_()));
        recipe.getFluidIngredients().forEach(i -> jsonIngredients.add((JsonElement)i.serialize()));
        ((TieredProcessingRecipe)((Object)recipe)).getRollableResults().forEach(o -> jsonOutputs.add(o.serialize()));
        recipe.getFluidResults().forEach(o -> jsonOutputs.add(FluidHelper.serializeFluidStack((FluidStack)o)));
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("results", (JsonElement)jsonOutputs);
        int processingDuration = recipe.getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            json.addProperty("heatRequirement", requiredHeat.serialize());
        }
        int recipeTier = ((TieredProcessingRecipe)((Object)recipe)).getRecipeTier();
        json.addProperty("recipeTier", (Number)recipeTier);
        int circuitNumber = ((TieredProcessingRecipe)((Object)recipe)).getCircuitNumber();
        json.addProperty("circuitNumber", (Number)circuitNumber);
        recipe.writeAdditional(json);
    }

    protected T readFromJson(ResourceLocation recipeId, JsonObject json) {
        TieredProcessingRecipeBuilder<T> builder = new TieredProcessingRecipeBuilder<T>(this.factory, recipeId);
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList fluidIngredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
            if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                fluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)je));
                continue;
            }
            ingredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            if (GsonHelper.m_13900_((JsonObject)jsonObject, (String)"fluid")) {
                fluidResults.add((Object)FluidHelper.deserializeFluidStack((JsonObject)jsonObject));
                continue;
            }
            results.add((Object)ProcessingOutput.deserialize((JsonElement)je));
        }
        builder.withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"processingTime")) {
            builder.duration(GsonHelper.m_13927_((JsonObject)json, (String)"processingTime"));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"heatRequirement")) {
            builder.requiresHeat(HeatCondition.deserialize((String)GsonHelper.m_13906_((JsonObject)json, (String)"heatRequirement")));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"recipeTier")) {
            builder.recipeTier(GsonHelper.m_13927_((JsonObject)json, (String)"recipeTier"));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"circuitNumber")) {
            builder.recipeCircuit(GsonHelper.m_13927_((JsonObject)json, (String)"circuitNumber"));
        }
        T recipe = builder.build();
        recipe.readAdditional(json);
        return recipe;
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, T recipe) {
        NonNullList ingredients = recipe.m_7527_();
        NonNullList fluidIngredients = recipe.getFluidIngredients();
        NonNullList<ProcessingOutput> outputs = ((TieredProcessingRecipe)((Object)recipe)).getRollableResults();
        NonNullList fluidOutputs = recipe.getFluidResults();
        buffer.m_130130_(ingredients.size());
        ingredients.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(fluidIngredients.size());
        fluidIngredients.forEach(i -> i.write(buffer));
        buffer.m_130130_(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.m_130130_(fluidOutputs.size());
        fluidOutputs.forEach(o -> o.writeToPacket(buffer));
        buffer.m_130130_(recipe.getProcessingDuration());
        buffer.m_130130_(recipe.getRequiredHeat().ordinal());
        buffer.m_130130_(((TieredProcessingRecipe)((Object)recipe)).getRecipeTier());
        buffer.m_130130_(((TieredProcessingRecipe)((Object)recipe)).getCircuitNumber());
        recipe.writeAdditional(buffer);
    }

    protected T readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList fluidIngredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidIngredients.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidResults.add((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
        T recipe = new TieredProcessingRecipeBuilder<T>(this.factory, recipeId).withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidIngredients((NonNullList<FluidIngredient>)fluidIngredients).withFluidOutputs((NonNullList<FluidStack>)fluidResults).duration(buffer.m_130242_()).requiresHeat(HeatCondition.values()[buffer.m_130242_()]).recipeTier(buffer.m_130242_()).recipeCircuit(buffer.m_130242_()).build();
        recipe.readAdditional(buffer);
        return recipe;
    }

    public final void write(JsonObject json, T recipe) {
        this.writeToJson(json, recipe);
    }

    public final T fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(FriendlyByteBuf buffer, T recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        return this.readFromBuffer(id, buffer);
    }

    public TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<T> getFactory() {
        return this.factory;
    }
}

