/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.advancement;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.SimpleCreateTrigger;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import electrolyte.greate.Greate;
import electrolyte.greate.foundation.advancement.GreateAdvancements;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GreateAdvancement {
    static final ResourceLocation BACKGROUND = Create.asResource((String)"textures/gui/advancements.png");
    static final String LANG = "advancement.greate.";
    static final String SECRET_SUFFIX = "\u00a77\n(Hidden Advancement)";
    private Advancement.Builder builder = Advancement.Builder.m_138353_();
    private SimpleCreateTrigger builtInTrigger;
    private GreateAdvancement parent;
    Advancement datagenResult;
    private String id;
    private String title;
    private String description;

    public GreateAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        if (!t.externalTrigger) {
            this.builtInTrigger = AllTriggers.addSimple((String)(id + "_builtin"));
            this.builder.m_138386_("0", (CriterionTriggerInstance)this.builtInTrigger.instance());
        }
        this.builder.m_138362_(t.icon, (Component)Component.m_237115_((String)this.titleKey()), (Component)Component.m_237115_((String)this.descriptionKey()).m_130938_(s -> s.m_178520_(14393875)), (ResourceLocation)(id.equals("root") ? BACKGROUND : null), t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        if (t.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        GreateAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    void save(Consumer<Advancement> advancementConsumer) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.datagenResult);
        }
        this.datagenResult = this.builder.m_138389_(advancementConsumer, Greate.id(this.id).toString());
    }

    void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private ItemStack icon;

        Builder() {
        }

        Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        Builder after(GreateAdvancement other) {
            GreateAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder title(String title) {
            GreateAdvancement.this.title = title;
            return this;
        }

        Builder description(String description) {
            GreateAdvancement.this.description = description;
            return this;
        }

        Builder awardedForFree() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0]));
        }

        Builder whenItemsConsumed(ItemLike ... items) {
            Builder builder = this.externalTrigger((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)items[0]));
            for (int i = 1; i < items.length; ++i) {
                builder = this.externalTrigger((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)items[i]));
            }
            return builder;
        }

        Builder whenItemConsumed(ItemLike item) {
            return this.externalTrigger((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)item));
        }

        Builder externalTrigger(CriterionTriggerInstance trigger) {
            GreateAdvancement.this.builder.m_138386_(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    static enum TaskType {
        SILENT(FrameType.TASK, false, false, false),
        NORMAL(FrameType.TASK, true, false, false),
        NOISY(FrameType.TASK, true, true, false),
        EXPERT(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true),
        SECRET_NOISY(FrameType.CHALLENGE, true, true, true);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

