/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import electrolyte.greate.Greate;
import electrolyte.greate.GreateValues;
import electrolyte.greate.content.kinetics.mixer.TieredBrewingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeSerializer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class GreateRuntimeRecipes {
    public static final Object2ObjectOpenHashMap<ResourceLocation, JsonObject> JSON_FILES = new Object2ObjectOpenHashMap();
    public static final ResourceManagerReloadListener LISTENER = r -> {
        JSON_FILES.clear();
        JSON_FILES.trim();
    };

    public static void convertGTRecipe(TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<TieredProcessingRecipe<?>> factory, GTRecipe recipe, boolean supportsDuration) {
        int recipeTier = GreateValues.convertGTEUToTier(recipe.getTickInputContents((RecipeCapability)EURecipeCapability.CAP));
        int recipeCircuit = TieredProcessingRecipe.getCircuitFromGTRecipe(recipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP));
        TieredProcessingRecipeBuilder builder = new Builder(factory, recipe.m_6423_()).withItemIngredientsGT(recipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP)).withItemOutputsGT(recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP)).recipeTier(recipeTier);
        if (recipe.getType() == GTRecipeTypes.ORE_WASHER_RECIPES) {
            if (recipeCircuit != 2) {
                return;
            }
            builder.build();
        } else {
            builder.withFluidIngredientsGT(recipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP)).withFluidOutputsGT(recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP)).duration(supportsDuration ? recipe.duration : 0).recipeCircuit(recipeCircuit).build();
        }
    }

    public static void convertCreateRecipe(TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<TieredProcessingRecipe<?>> factory, ResourceLocation recipeId, JsonElement recipeJson) {
        TieredProcessingRecipeSerializer serializer = new TieredProcessingRecipeSerializer(factory);
        TieredProcessingRecipe<?> recipe = serializer.fromJson(recipeId, recipeJson.getAsJsonObject());
        new Builder(factory, recipe.m_6423_()).withItemIngredients((NonNullList<Ingredient>)recipe.m_7527_()).withFluidIngredients((NonNullList<FluidIngredient>)recipe.getFluidIngredients()).withItemOutputs(recipe.getRollableResults()).withFluidOutputs((NonNullList<FluidStack>)recipe.getFluidResults()).duration(recipe.getProcessingDuration()).requiresHeat(recipe.getRequiredHeat()).recipeTier(0).build();
    }

    public static void convertPotionRecipe(MixingRecipe recipe) {
        new Builder<TieredBrewingRecipe>(TieredBrewingRecipe::new, recipe.m_6423_()).withItemIngredients((NonNullList<Ingredient>)recipe.m_7527_()).withFluidIngredients((NonNullList<FluidIngredient>)recipe.getFluidIngredients()).withFluidOutputs((NonNullList<FluidStack>)recipe.getFluidResults()).duration(recipe.getProcessingDuration()).requiresHeat(recipe.getRequiredHeat()).recipeTier(0).build();
    }

    private static class Builder<T extends TieredProcessingRecipe<?>>
    extends TieredProcessingRecipeBuilder<T> {
        public Builder(TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<T> factory, ResourceLocation recipeId) {
            super(factory, Greate.id("integration/" + recipeId.toString().replace(":", "/")));
        }

        @Override
        public T build() {
            Object t = super.build();
            TieredProcessingRecipeBuilder.DataGenResult result = new TieredProcessingRecipeBuilder.DataGenResult(t, Collections.emptyList());
            JSON_FILES.put((Object)result.m_6445_(), (Object)result.m_125966_());
            return t;
        }
    }
}

