/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraftforge.fluids.FluidStack;

public class TieredRecipeConditions {
    public static Predicate<Recipe<?>> firstIngredientMatches(ItemStack stack) {
        return r -> {
            if (r instanceof ProcessingRecipe || r instanceof StonecutterRecipe) {
                return !r.m_7527_().isEmpty() && ((Ingredient)r.m_7527_().get(0)).test(stack);
            }
            return false;
        };
    }

    public static Predicate<Recipe<?>> firstIngredientCountMatches(ItemStack stack) {
        return r -> {
            if (r instanceof TieredProcessingRecipe) {
                return ((Ingredient)r.m_7527_().get(0)).m_43908_()[0].m_41613_() <= stack.m_41613_();
            }
            return true;
        };
    }

    public static Predicate<Recipe<?>> firstFluidMatches(FluidStack stack) {
        return r -> {
            if (r instanceof StonecutterRecipe) {
                return true;
            }
            if (r instanceof ProcessingRecipe) {
                ProcessingRecipe pr = (ProcessingRecipe)r;
                if (!pr.getFluidIngredients().isEmpty()) {
                    boolean testFluid = ((FluidIngredient)pr.getFluidIngredients().get(0)).test(stack);
                    return testFluid && ((FluidIngredient)pr.getFluidIngredients().get(0)).getRequiredAmount() <= stack.getAmount();
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<Recipe<?>> outputMatchesFilter(FilteringBehaviour filter) {
        return r -> {
            if (r instanceof StonecutterRecipe) {
                return filter.test(r.m_8043_(filter.getWorld().m_9598_()));
            }
            if (r instanceof ProcessingRecipe) {
                ProcessingRecipe pr = (ProcessingRecipe)r;
                return filter.test(pr.m_8043_(filter.getWorld().m_9598_()));
            }
            return false;
        };
    }

    public static Predicate<Recipe<?>> isEqualOrAboveTier(int machineTier) {
        return r -> {
            if (r instanceof TieredProcessingRecipe) {
                TieredProcessingRecipe pr = (TieredProcessingRecipe)((Object)r);
                return pr.getRecipeTier() <= machineTier;
            }
            return true;
        };
    }

    public static Predicate<Recipe<?>> circuitMatches(int machineCircuitNumber) {
        return r -> {
            TieredProcessingRecipe pr;
            if (r instanceof TieredProcessingRecipe && (pr = (TieredProcessingRecipe)((Object)r)).getCircuitNumber() != -1) {
                return pr.getCircuitNumber() == machineCircuitNumber;
            }
            return true;
        };
    }
}

