/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.machines.GreateRecipeTypes;
import electrolyte.greate.content.gtceu.material.CogwheelProperty;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.registry.GreateMaterials;
import electrolyte.greate.registry.GreateTagPrefixes;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class GreateSequencedAssemblyRecipes {
    private static final Reference2IntMap<TagPrefix> INSULATION_AMOUNT = (Reference2IntMap)Util.m_137469_((Object)new Reference2IntOpenHashMap(), map -> {
        map.put((Object)TagPrefix.cableGtSingle, 1);
        map.put((Object)TagPrefix.cableGtDouble, 1);
        map.put((Object)TagPrefix.cableGtQuadruple, 2);
        map.put((Object)TagPrefix.cableGtOctal, 3);
        map.put((Object)TagPrefix.cableGtHex, 5);
    });

    public static void register(Consumer<FinishedRecipe> provider) {
        new SequencedAssemblyRecipeBuilder(Greate.id("precision_mechanism")).require(AllTags.forgeItemTag((String)"plates/gold")).transitionTo((ItemLike)AllItems.INCOMPLETE_PRECISION_MECHANISM).addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.cogwheel, (Material)GreateMaterials.AndesiteAlloy).m_41720_())).addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)GreateMaterials.AndesiteAlloy).m_41720_())).addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)Items.f_42749_)).addOutput((ItemLike)AllItems.PRECISION_MECHANISM.get(), 120.0f).addOutput((ItemLike)AllItems.GOLDEN_SHEET.get(), 8.0f).addOutput((ItemLike)AllItems.ANDESITE_ALLOY.get(), 8.0f).addOutput((ItemLike)AllBlocks.COGWHEEL.get(), 5.0f).addOutput((ItemLike)Items.f_42587_, 3.0f).addOutput((ItemLike)AllBlocks.SHAFT.get(), 2.0f).addOutput((ItemLike)AllItems.CRUSHED_GOLD.get(), 2.0f).addOutput((ItemLike)Items.f_42416_, 1.0f).addOutput((ItemLike)Items.f_42524_, 1.0f).loops(5).build(provider);
    }

    public static void registerMaterialRecipes(Consumer<FinishedRecipe> provider, Material material) {
        CogwheelProperty cogwheelProperty;
        WireProperties property = (WireProperties)material.getProperty(PropertyKey.WIRE);
        if (property != null) {
            GreateSequencedAssemblyRecipes.addRecipe(provider, property, TagPrefix.wireGtSingle, material);
            GreateSequencedAssemblyRecipes.addRecipe(provider, property, TagPrefix.wireGtDouble, material);
            GreateSequencedAssemblyRecipes.addRecipe(provider, property, TagPrefix.wireGtQuadruple, material);
            GreateSequencedAssemblyRecipes.addRecipe(provider, property, TagPrefix.wireGtOctal, material);
            GreateSequencedAssemblyRecipes.addRecipe(provider, property, TagPrefix.wireGtHex, material);
        }
        if ((cogwheelProperty = (CogwheelProperty)material.getProperty(GreatePropertyKeys.COGWHEEL)) != null) {
            GreateSequencedAssemblyRecipes.addCogwheelDeployingRecipes(provider, material, cogwheelProperty);
        }
    }

    private static void addCogwheelDeployingRecipes(Consumer<FinishedRecipe> provider, Material material, CogwheelProperty property) {
        Material prevMat = property.getPreviousMaterial();
        new SequencedAssemblyRecipeBuilder(Greate.id(material.getName() + "_large_cogwheel")).require((ItemLike)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.shaft, (Material)material).m_41720_()).transitionTo((ItemLike)ChemicalHelper.get((TagPrefix)GreateTagPrefixes.cogwheel, (Material)material).m_41720_()).addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)prevMat).m_41720_())).addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)prevMat).m_41720_())).addOutput(ChemicalHelper.get((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)material), 1.0f).loops(1).build(provider);
    }

    private static void addRecipe(Consumer<FinishedRecipe> provider, WireProperties property, TagPrefix wirePrefix, Material material) {
        if (property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        TagPrefix cablePrefix = TagPrefix.get((String)("cable" + wirePrefix.name().substring(4)));
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.getInt((Object)cablePrefix);
        if (voltageTier >= 4) {
            SequencedAssemblyRecipeBuilder siliconeAssemblyBuilder = new SequencedAssemblyRecipeBuilder(Greate.id(String.format("%s_cable_%d_silicone", material.getName(), cableAmount))).require((ItemLike)ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material).m_41720_()).transitionTo((ItemLike)ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material).m_41720_()).addOutput(ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material), 1.0f).loops(1);
            GTRecipeBuilder siliconeCoatingFactoryBuilder = GreateRecipeTypes.WIRE_COATING_RECIPES.recipeBuilder(Greate.id(String.format("%s_cable_%d_silicone", material.getName(), cableAmount))).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
            if (voltageTier >= 6) {
                siliconeAssemblyBuilder.addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.foil, (Material)GTMaterials.PolyphenyleneSulfide, (int)insulationAmount).m_41720_()));
                siliconeCoatingFactoryBuilder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
            }
            siliconeAssemblyBuilder.addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.foil, (Material)GTMaterials.PolyvinylChloride, (int)insulationAmount).m_41720_()));
            siliconeAssemblyBuilder.addStep(FillingRecipe::new, r -> r.require(FluidIngredient.fromFluid((Fluid)GTMaterials.SiliconeRubber.getFluid(), (int)(144 * insulationAmount / 2))));
            siliconeAssemblyBuilder.build(provider);
            siliconeCoatingFactoryBuilder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            siliconeCoatingFactoryBuilder.inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / 2));
            siliconeCoatingFactoryBuilder.save(provider);
            SequencedAssemblyRecipeBuilder styreneAssemblyBuilder = new SequencedAssemblyRecipeBuilder(Greate.id(String.format("%s_cable_%d_styrene", material.getName(), cableAmount))).require((ItemLike)ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material).m_41720_()).transitionTo((ItemLike)ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material).m_41720_()).addOutput(ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material), 1.0f).loops(1);
            GTRecipeBuilder styreneCoatingFactoryBuilder = GreateRecipeTypes.WIRE_COATING_RECIPES.recipeBuilder(Greate.id(String.format("%s_cable_%d_styrene", material.getName(), cableAmount))).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).outputItems(cablePrefix, material);
            if (voltageTier >= 6) {
                styreneAssemblyBuilder.addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.foil, (Material)GTMaterials.PolyphenyleneSulfide, (int)insulationAmount).m_41720_()));
                styreneCoatingFactoryBuilder.inputItems(TagPrefix.foil, GTMaterials.PolyphenyleneSulfide, insulationAmount);
            }
            styreneAssemblyBuilder.addStep(DeployerApplicationRecipe::new, r -> r.require((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.foil, (Material)GTMaterials.PolyvinylChloride, (int)insulationAmount).m_41720_()));
            styreneAssemblyBuilder.addStep(FillingRecipe::new, r -> r.require(FluidIngredient.fromFluid((Fluid)GTMaterials.StyreneButadieneRubber.getFluid(), (int)(144 * insulationAmount / 4))));
            styreneAssemblyBuilder.build(provider);
            styreneCoatingFactoryBuilder.inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride, insulationAmount);
            styreneCoatingFactoryBuilder.inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4));
            styreneCoatingFactoryBuilder.save(provider);
        }
    }
}

