/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.machines.GreateRecipeTypes;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;

public class GreateSpoutRecipes {
    private static final Reference2IntMap<TagPrefix> INSULATION_AMOUNT = (Reference2IntMap)Util.m_137469_((Object)new Reference2IntOpenHashMap(), map -> {
        map.put((Object)TagPrefix.cableGtSingle, 1);
        map.put((Object)TagPrefix.cableGtDouble, 1);
        map.put((Object)TagPrefix.cableGtQuadruple, 2);
        map.put((Object)TagPrefix.cableGtOctal, 3);
        map.put((Object)TagPrefix.cableGtHex, 5);
    });

    public static void registerCableRecipes(Consumer<FinishedRecipe> provider, Material material) {
        WireProperties property = (WireProperties)material.getProperty(PropertyKey.WIRE);
        if (property != null) {
            GreateSpoutRecipes.addRecipe(provider, property, TagPrefix.wireGtSingle, material);
            GreateSpoutRecipes.addRecipe(provider, property, TagPrefix.wireGtDouble, material);
            GreateSpoutRecipes.addRecipe(provider, property, TagPrefix.wireGtQuadruple, material);
            GreateSpoutRecipes.addRecipe(provider, property, TagPrefix.wireGtOctal, material);
            GreateSpoutRecipes.addRecipe(provider, property, TagPrefix.wireGtHex, material);
        }
    }

    public static void addRecipe(Consumer<FinishedRecipe> provider, WireProperties property, TagPrefix wirePrefix, Material material) {
        if (property.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        TagPrefix cablePrefix = TagPrefix.get((String)("cable" + wirePrefix.name().substring(4)));
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        int insulationAmount = INSULATION_AMOUNT.get((Object)cablePrefix);
        if (voltageTier < 4) {
            new ProcessingRecipeBuilder(FillingRecipe::new, Greate.id(String.format("%s_cable_%d_rubber", material.getName(), cableAmount))).withItemIngredients(new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material)})}).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluid((Fluid)GTMaterials.Rubber.getFluid(), (int)(144 * insulationAmount))}).withSingleItemOutput(ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material)).build(provider);
            GreateRecipeTypes.WIRE_COATING_RECIPES.recipeBuilder(Greate.id(String.format("cover_%s_%s_rubber", material.getName(), cableAmount))).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).inputFluids(GTMaterials.Rubber.getFluid(144 * insulationAmount)).outputItems(cablePrefix, material).save(provider);
            new ProcessingRecipeBuilder(FillingRecipe::new, Greate.id(String.format("%s_cable_%d_slicone", material.getName(), cableAmount))).withItemIngredients(new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material)})}).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluid((Fluid)GTMaterials.SiliconeRubber.getFluid(), (int)(144 * insulationAmount / 2))}).withSingleItemOutput(ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material)).build(provider);
            GreateRecipeTypes.WIRE_COATING_RECIPES.recipeBuilder(Greate.id(String.format("cover_%s_%s_silicone", material.getName(), cableAmount))).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).inputFluids(GTMaterials.SiliconeRubber.getFluid(144 * insulationAmount / 2)).outputItems(cablePrefix, material).save(provider);
            new ProcessingRecipeBuilder(FillingRecipe::new, Greate.id(String.format("%s_cable_%d_styrene_butadiene", material.getName(), cableAmount))).withItemIngredients(new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)wirePrefix, (Material)material)})}).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluid((Fluid)GTMaterials.StyreneButadieneRubber.getFluid(), (int)(144 * insulationAmount / 4))}).withSingleItemOutput(ChemicalHelper.get((TagPrefix)cablePrefix, (Material)material)).build(provider);
            GreateRecipeTypes.WIRE_COATING_RECIPES.recipeBuilder(Greate.id(String.format("cover_%s_%s_styrene_butadiene", material.getName(), cableAmount))).EUt((long)GTValues.VA[0]).duration(100).inputItems(wirePrefix, material).inputFluids(GTMaterials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4)).outputItems(cablePrefix, material).save(provider);
        }
    }
}

