/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.foundation.data.recipe.removal;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class CableRecipeRemoval {
    public static void disableCableRecipes(Consumer<ResourceLocation> provider) {
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            WireProperties property;
            if (material.hasFlag(MaterialFlags.NO_UNIFICATION) || (property = (WireProperties)material.getProperty(PropertyKey.WIRE)) == null) continue;
            CableRecipeRemoval.removeRecipe(provider, property, TagPrefix.wireGtSingle, material);
            CableRecipeRemoval.removeRecipe(provider, property, TagPrefix.wireGtDouble, material);
            CableRecipeRemoval.removeRecipe(provider, property, TagPrefix.wireGtQuadruple, material);
            CableRecipeRemoval.removeRecipe(provider, property, TagPrefix.wireGtOctal, material);
            CableRecipeRemoval.removeRecipe(provider, property, TagPrefix.wireGtHex, material);
        }
    }

    public static void removeRecipe(Consumer<ResourceLocation> recipe, WireProperties property, TagPrefix wirePrefix, Material material) {
        if (property.isSuperconductor()) {
            return;
        }
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        int factor = (int)(wirePrefix.getMaterialAmount(material) * 2L / 3628800L);
        if (voltageTier <= 1) {
            recipe.accept(GTCEu.id((String)("shapeless/" + material.getName() + "_cable_" + factor)));
            recipe.accept(GTCEu.id((String)("packer/cover_" + material.getName() + "_wire_gt_" + wirePrefix.name().substring(6).toLowerCase())));
        }
        if (voltageTier <= 4) {
            recipe.accept(GTCEu.id((String)("assembler/cover_" + material.getName() + "_wire_gt_" + wirePrefix.name.substring(6).toLowerCase() + "_rubber")));
        }
        recipe.accept(GTCEu.id((String)("assembler/cover_" + material.getName() + "_wire_gt_" + wirePrefix.name.substring(6).toLowerCase() + "_silicone")));
        recipe.accept(GTCEu.id((String)("assembler/cover_" + material.getName() + "_wire_gt_" + wirePrefix.name.substring(6).toLowerCase() + "_styrene_butadiene")));
    }
}

