/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.infrastructure.config;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import electrolyte.greate.infrastructure.config.GreateConfigs;

public class GConfigUtility {
    public static int getMaxCapacityFromTier(int tier) {
        return switch (tier) {
            case 0 -> (Integer)GreateConfigs.server().kinetics.tierValues.andesiteMaxCapacity.get();
            case 1 -> (Integer)GreateConfigs.server().kinetics.tierValues.steelMaxCapacity.get();
            case 2 -> (Integer)GreateConfigs.server().kinetics.tierValues.aluminiumMaxCapacity.get();
            case 3 -> (Integer)GreateConfigs.server().kinetics.tierValues.stainlessSteelMaxCapacity.get();
            case 4 -> (Integer)GreateConfigs.server().kinetics.tierValues.titaniumMaxCapacity.get();
            case 5 -> (Integer)GreateConfigs.server().kinetics.tierValues.tungstensteelMaxCapacity.get();
            case 6 -> (Integer)GreateConfigs.server().kinetics.tierValues.palladiumMaxCapacity.get();
            case 7 -> (Integer)GreateConfigs.server().kinetics.tierValues.naquadahMaxCapacity.get();
            case 8 -> (Integer)GreateConfigs.server().kinetics.tierValues.darmstadtiumMaxCapacity.get();
            case 9 -> (Integer)GreateConfigs.server().kinetics.tierValues.neutroniumMaxCapacity.get();
            default -> throw new IllegalStateException("Unexpected value: " + tier);
        };
    }

    public static int getBeltLengthFromMaterial(Material beltMaterial) {
        if (beltMaterial == GTMaterials.Rubber) {
            return (Integer)GreateConfigs.server().kinetics.beltValues.rubberMaxBeltLength.get();
        }
        if (beltMaterial == GTMaterials.SiliconeRubber) {
            return (Integer)GreateConfigs.server().kinetics.beltValues.siliconeMaxBeltLength.get();
        }
        if (beltMaterial == GTMaterials.Polyethylene) {
            return (Integer)GreateConfigs.server().kinetics.beltValues.polyethyleneMaxBeltLength.get();
        }
        if (beltMaterial == GTMaterials.Polytetrafluoroethylene) {
            return (Integer)GreateConfigs.server().kinetics.beltValues.polytetrafluoroethyleneMaxBeltLength.get();
        }
        if (beltMaterial == GTMaterials.Polybenzimidazole) {
            return (Integer)GreateConfigs.server().kinetics.beltValues.polybenzimidazoleMaxBeltLength.get();
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(beltMaterial));
    }

    public static double getPumpPressureFromTier(int tier) {
        return switch (tier) {
            case 0 -> (Double)GreateConfigs.server().kinetics.pumpValues.andesitePressure.get();
            case 1 -> (Double)GreateConfigs.server().kinetics.pumpValues.steelPressure.get();
            case 2 -> (Double)GreateConfigs.server().kinetics.pumpValues.aluminiumPressure.get();
            case 3 -> (Double)GreateConfigs.server().kinetics.pumpValues.stainlessSteelPressure.get();
            case 4 -> (Double)GreateConfigs.server().kinetics.pumpValues.titaniumPressure.get();
            case 5 -> (Double)GreateConfigs.server().kinetics.pumpValues.tungstensteelPressure.get();
            case 6 -> (Double)GreateConfigs.server().kinetics.pumpValues.palladiumPressure.get();
            case 7 -> (Double)GreateConfigs.server().kinetics.pumpValues.naquadahPressure.get();
            case 8 -> (Double)GreateConfigs.server().kinetics.pumpValues.darmstadtiumPressure.get();
            case 9 -> (Double)GreateConfigs.server().kinetics.pumpValues.neutroniumPressure.get();
            default -> throw new IllegalStateException("Unexpected value: " + tier);
        };
    }
}

