/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import electrolyte.greate.content.kinetics.simpleRelays.ITieredKineticBlockEntity;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KineticNetwork.class})
public abstract class MixinKineticNetwork {
    @Shadow(remap=false)
    public Map<KineticBlockEntity, Float> members;
    @Shadow(remap=false)
    private float currentCapacity;
    @Shadow(remap=false)
    private float currentStress;
    @Unique
    private float greate_currentMaxCapacity;

    @Shadow(remap=false)
    public abstract void sync();

    @Shadow(remap=false)
    public abstract int getSize();

    @Shadow(remap=false)
    public abstract float calculateStress();

    @Shadow(remap=false)
    public abstract float calculateCapacity();

    @Inject(method={"initFromTE"}, at={@At(value="RETURN")}, remap=false)
    private void greate_initFromTE(float maxStress, float currentStress, int members, CallbackInfo ci) {
        this.greate_updateMaxCapacity();
    }

    @Inject(method={"updateNetwork"}, at={@At(value="HEAD")}, remap=false)
    private void greate_updateNetwork(CallbackInfo ci) {
        float newStress = this.calculateStress();
        float newMaxStress = this.calculateCapacity();
        float newMaxCapacity = this.greate_calculateMaxCapacity();
        if (this.currentStress != newStress || this.currentCapacity != newMaxStress || this.greate_currentMaxCapacity != newMaxCapacity) {
            this.currentStress = newStress;
            this.currentCapacity = newMaxStress;
            this.greate_currentMaxCapacity = newMaxCapacity;
            this.sync();
        }
    }

    @Unique
    private void greate_updateMaxCapacity() {
        float newMaxCapacity = this.greate_calculateMaxCapacity();
        if (this.greate_currentMaxCapacity != newMaxCapacity) {
            this.greate_currentMaxCapacity = newMaxCapacity;
            this.sync();
        }
    }

    @Inject(method={"updateCapacityFor"}, at={@At(value="RETURN")}, remap=false)
    private void greate_updateCapacityFor(KineticBlockEntity be, float capacity, CallbackInfo ci) {
        this.greate_updateMaxCapacity();
    }

    @Inject(method={"updateStressFor"}, at={@At(value="RETURN")}, remap=false)
    private void greate_updateStressFor(KineticBlockEntity be, float stress, CallbackInfo ci) {
        this.greate_updateMaxCapacity();
    }

    @Unique
    private float greate_calculateMaxCapacity() {
        float presentMaxCapacity = 2.1474836E9f;
        for (KineticBlockEntity be : this.members.keySet()) {
            ITieredKineticBlockEntity itkbe;
            if (!(be instanceof ITieredKineticBlockEntity) || !(presentMaxCapacity > (itkbe = (ITieredKineticBlockEntity)be).getMaxCapacityFromBlock(be.m_58900_().m_60734_()))) continue;
            presentMaxCapacity = itkbe.getMaxCapacityFromBlock(be.m_58900_().m_60734_());
        }
        return presentMaxCapacity;
    }

    @ModifyReturnValue(method={"calculateCapacity"}, at={@At(value="RETURN")}, remap=false)
    private float greate_calculateCapacity(float original) {
        this.greate_updateMaxCapacity();
        return Math.min(original, this.greate_currentMaxCapacity);
    }
}

