/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import electrolyte.greate.Greate;
import electrolyte.greate.GreateValues;
import electrolyte.greate.compat.kubejs.GreateKubeJSHelper;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipe;
import electrolyte.greate.content.processing.recipe.TieredProcessingRecipeBuilder;
import electrolyte.greate.foundation.data.recipe.GreateRuntimeRecipes;
import electrolyte.greate.foundation.data.recipe.removal.GreateRecipeRemoval;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class}, priority=1099)
public class MixinRecipeManager {
    @Shadow
    public Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> f_44007_;
    @Shadow(remap=false)
    @Final
    private ICondition.IContext context;

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void greate_apply(Map<ResourceLocation, JsonElement> pMap, ResourceManager pResourceManager, ProfilerFiller pProfiler, CallbackInfo ci) {
        GreateRecipeRemoval.register(recipe -> {
            if (pMap.remove(recipe) == null) {
                Greate.LOGGER.error("Unable to remove recipe {}.", recipe);
            }
        });
        long currentTime = System.currentTimeMillis();
        Greate.LOGGER.info("Converting GT & Create recipes...");
        if (ModList.get().isLoaded("kubejs")) {
            GreateKubeJSHelper.kubeStuff();
        }
        int recipeCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> recipeEntry : pMap.entrySet()) {
            ResourceLocation resourceLocation = recipeEntry.getKey();
            JsonElement jsonElement = recipeEntry.getValue();
            try {
                TieredProcessingRecipeBuilder.TieredProcessingRecipeFactory<TieredProcessingRecipe<?>> factory;
                JsonObject recipeJson;
                if (!jsonElement.isJsonObject() || !(recipeJson = jsonElement.getAsJsonObject()).get("type").getAsString().startsWith("create") && !recipeJson.get("type").getAsString().startsWith("gtceu")) continue;
                String type = jsonElement.getAsJsonObject().get("type").getAsString();
                if (!CraftingHelper.processConditions((JsonObject)recipeJson, (String)"conditions", (ICondition.IContext)this.context) || (factory = GreateValues.getFactory(resourceLocation)) == null) continue;
                if (type.startsWith("gtceu")) {
                    GTRecipe recipe2 = GTRecipeSerializer.SERIALIZER.fromJson(resourceLocation, recipeJson);
                    GreateRuntimeRecipes.convertGTRecipe(factory, recipe2, !type.startsWith(GTRecipeTypes.BENDER_RECIPES.registryName.toString()));
                } else if (type.startsWith("create")) {
                    GreateRuntimeRecipes.convertCreateRecipe(factory, resourceLocation, jsonElement);
                }
                ++recipeCount;
            }
            catch (JsonSyntaxException e) {
                Greate.LOGGER.warn("Unable to parse recipe {}, it will be skipped. Check debug.log for erroring JSON.)", (Object)resourceLocation);
                Greate.LOGGER.debug("Unable to parse recipe {}, erroring JSON is: {}", (Object)resourceLocation, (Object)jsonElement);
            }
        }
        for (MixingRecipe potionRecipe : PotionMixingRecipes.ALL) {
            GreateRuntimeRecipes.convertPotionRecipe(potionRecipe);
            ++recipeCount;
        }
        Greate.LOGGER.info("Finished processing {} recipes in {} ms", (Object)recipeCount, (Object)(System.currentTimeMillis() - currentTime));
        pMap.putAll((Map<ResourceLocation, JsonElement>)GreateRuntimeRecipes.JSON_FILES);
    }
}

