/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.gtceu.material.KineticProperty;
import electrolyte.greate.content.kinetics.simpleRelays.TieredCogwheelBlock;
import electrolyte.greate.content.kinetics.simpleRelays.encased.TieredEncasedCogwheelBlock;
import electrolyte.greate.foundation.data.GreateBlockStateGen;
import electrolyte.greate.foundation.data.GreateBuilderTransformers;
import electrolyte.greate.infrastructure.config.GStress;
import electrolyte.greate.registry.GreateTagPrefixes;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;

public class Cogwheels {
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredCogwheelBlock>> COGWHEELS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> ANDESITE_ENCASED_COGWHEELS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> BRASS_ENCASED_COGWHEELS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredCogwheelBlock>> LARGE_COGWHEELS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> ANDESITE_ENCASED_LARGE_COGWHEELS_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> BRASS_ENCASED_LARGE_COGWHEELS_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<TieredCogwheelBlock>> COGWHEELS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> ANDESITE_ENCASED_COGWHEELS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> BRASS_ENCASED_COGWHEELS;
    public static Table<TagPrefix, Material, BlockEntry<TieredCogwheelBlock>> LARGE_COGWHEELS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> ANDESITE_ENCASED_LARGE_COGWHEELS;
    public static Table<TagPrefix, Material, BlockEntry<TieredEncasedCogwheelBlock>> BRASS_ENCASED_LARGE_COGWHEELS;

    public static void register() {
        Greate.REGISTRATE.setCreativeTab(Greate.GREATE_TAB);
        Cogwheels.generateCogwheels();
        Cogwheels.generateLargeCogwheels();
        Cogwheels.generateAndesiteEncasedCogwheels();
        Cogwheels.generateBrassEncasedCogwheels();
    }

    public static void generateCogwheels() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry cogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block(mat.getName() + "_cogwheel", TieredCogwheelBlock::small).initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_)).properties(p -> p.m_284180_(MapColor.f_283762_)).transform(GStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(GreateBlockStateGen.tieredCogwheelProvider(false)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).onRegister(c -> c.setTier(tier))).item(CogwheelBlockItem::new).build()).register();
            COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.cogwheel, (Object)mat, (Object)cogwheelEntry);
        }
        COGWHEELS = COGWHEELS_BUILDER.build();
    }

    public static void generateLargeCogwheels() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry cogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("large_" + mat.getName() + "_cogwheel", TieredCogwheelBlock::large).initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56736_)).properties(p -> p.m_284180_(MapColor.f_283762_)).transform(GStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(GreateBlockStateGen.tieredCogwheelProvider(true)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).onRegister(c -> c.setTier(tier))).item(CogwheelBlockItem::new).build()).register();
            LARGE_COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.largeCogwheel, (Object)mat, (Object)cogwheelEntry);
        }
        LARGE_COGWHEELS = LARGE_COGWHEELS_BUILDER.build();
    }

    public static void generateAndesiteEncasedCogwheels() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            Supplier<TieredCogwheelBlock> cogwheelSupplier = () -> (TieredCogwheelBlock)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.cogwheel, (Material)mat);
            BlockEntry cogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("andesite_encased_" + mat.getName() + "_cogwheel", p -> TieredEncasedCogwheelBlock.small(p, () -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get(), mat)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedCogwheel(cogwheelSupplier, () -> AllSpriteShifts.ANDESITE_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheelSupplier))).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(AllSpriteShifts.ANDESITE_CASING, Couple.create((Object)AllSpriteShifts.ANDESITE_ENCASED_COGWHEEL_SIDE, (Object)AllSpriteShifts.ANDESITE_ENCASED_COGWHEEL_OTHERSIDE))))).onRegister(c -> c.setTier(tier))).transform(TagGen.axeOrPickaxe())).register();
            ANDESITE_ENCASED_COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.andesiteEncasedCogwheel, (Object)mat, (Object)cogwheelEntry);
            Supplier<TieredCogwheelBlock> largeCogwheelSupplier = () -> (TieredCogwheelBlock)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)mat);
            BlockEntry largeCogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("andesite_encased_large_" + mat.getName() + "_cogwheel", p -> TieredEncasedCogwheelBlock.large(p, () -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get(), mat)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedLargeCogwheel(largeCogwheelSupplier, () -> AllSpriteShifts.ANDESITE_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo(largeCogwheelSupplier))).transform(TagGen.axeOrPickaxe())).onRegister(c -> c.setTier(tier))).register();
            ANDESITE_ENCASED_LARGE_COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.andesiteEncasedLargeCogwheel, (Object)mat, (Object)largeCogwheelEntry);
        }
        ANDESITE_ENCASED_COGWHEELS = ANDESITE_ENCASED_COGWHEELS_BUILDER.build();
        ANDESITE_ENCASED_LARGE_COGWHEELS = ANDESITE_ENCASED_LARGE_COGWHEELS_BUILDER.build();
    }

    public static void generateBrassEncasedCogwheels() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            Supplier<TieredCogwheelBlock> cogwheelSupplier = () -> (TieredCogwheelBlock)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.cogwheel, (Material)mat);
            BlockEntry cogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("brass_encased_" + mat.getName() + "_cogwheel", p -> TieredEncasedCogwheelBlock.small(p, () -> ((BlockEntry)AllBlocks.BRASS_CASING).get(), mat)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedCogwheel(cogwheelSupplier, () -> AllSpriteShifts.BRASS_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheelSupplier))).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(AllSpriteShifts.BRASS_CASING, Couple.create((Object)AllSpriteShifts.BRASS_ENCASED_COGWHEEL_SIDE, (Object)AllSpriteShifts.BRASS_ENCASED_COGWHEEL_OTHERSIDE))))).onRegister(c -> c.setTier(tier))).transform(TagGen.axeOrPickaxe())).register();
            BRASS_ENCASED_COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.brassEncasedCogwheel, (Object)mat, (Object)cogwheelEntry);
            Supplier<TieredCogwheelBlock> largeCogwheelSupplier = () -> (TieredCogwheelBlock)ChemicalHelper.getBlock((TagPrefix)GreateTagPrefixes.largeCogwheel, (Material)mat);
            BlockEntry largeCogwheelEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block("brass_encased_large_" + mat.getName() + "_cogwheel", p -> TieredEncasedCogwheelBlock.large(p, () -> ((BlockEntry)AllBlocks.BRASS_CASING).get(), mat)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(GreateBuilderTransformers.tieredEncasedLargeCogwheel(largeCogwheelSupplier, () -> AllSpriteShifts.BRASS_CASING))).transform((NonNullFunction)EncasingRegistry.addVariantTo(largeCogwheelSupplier))).transform(TagGen.axeOrPickaxe())).onRegister(c -> c.setTier(tier))).register();
            BRASS_ENCASED_LARGE_COGWHEELS_BUILDER.put((Object)GreateTagPrefixes.brassEncasedLargeCogwheel, (Object)mat, (Object)largeCogwheelEntry);
        }
        BRASS_ENCASED_COGWHEELS = BRASS_ENCASED_COGWHEELS_BUILDER.build();
        BRASS_ENCASED_LARGE_COGWHEELS = BRASS_ENCASED_LARGE_COGWHEELS_BUILDER.build();
    }
}

