/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.gtceu.material.KineticProperty;
import electrolyte.greate.content.kinetics.gearbox.TieredGearboxBlock;
import electrolyte.greate.content.kinetics.gearbox.TieredVerticalGearboxItem;
import electrolyte.greate.foundation.data.GreateBuilderTransformers;
import electrolyte.greate.infrastructure.config.GStress;
import electrolyte.greate.registry.GreateTagPrefixes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class Gearboxes {
    static ImmutableTable.Builder<TagPrefix, Material, BlockEntry<TieredGearboxBlock>> GEARBOXES_BUILDER = ImmutableTable.builder();
    static ImmutableTable.Builder<TagPrefix, Material, ItemEntry<TieredVerticalGearboxItem>> VERTICAL_GEARBOXES_BUILDER = ImmutableTable.builder();
    public static Table<TagPrefix, Material, BlockEntry<TieredGearboxBlock>> GEARBOXES;
    public static Table<TagPrefix, Material, ItemEntry<TieredVerticalGearboxItem>> VERTICAL_GEARBOXES;

    public static void register() {
        Greate.REGISTRATE.setCreativeTab(Greate.GREATE_TAB);
        Gearboxes.generateGearboxes();
        Gearboxes.generateVerticalGearboxes();
    }

    public static void generateGearboxes() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            KineticProperty prop = (KineticProperty)mat.getProperty(GreatePropertyKeys.KINETIC);
            int tier = prop.getTier();
            BlockEntry gearboxEntry = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)Greate.REGISTRATE.block(mat.getName() + "_gearbox", p -> new TieredGearboxBlock((BlockBehaviour.Properties)p, mat)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_284180_(MapColor.f_283819_).m_278166_(PushReaction.PUSH_ONLY)).transform(GStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).transform(GreateBuilderTransformers.tieredGearbox())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(AllSpriteShifts.ANDESITE_CASING)))).onRegister(CreateRegistrate.casingConnectivity((block, c) -> c.make((Block)block, AllSpriteShifts.ANDESITE_CASING, (s, f) -> f.m_122434_() == s.m_61143_((Property)GearboxBlock.AXIS))))).onRegister(c -> c.setTier(tier))).register();
            GEARBOXES_BUILDER.put((Object)GreateTagPrefixes.gearbox, (Object)mat, (Object)gearboxEntry);
        }
        GEARBOXES = GEARBOXES_BUILDER.build();
    }

    public static void generateVerticalGearboxes() {
        for (Material mat : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            if (!mat.hasProperty(GreatePropertyKeys.KINETIC) || !mat.hasProperty(GreatePropertyKeys.COGWHEEL)) continue;
            ItemEntry gearboxEntry = ((ItemBuilder)Greate.REGISTRATE.item(mat.getName() + "_vertical_gearbox", p -> new TieredVerticalGearboxItem((Item.Properties)p, mat)).transform(GreateBuilderTransformers.tieredGearboxVertical())).register();
            VERTICAL_GEARBOXES_BUILDER.put((Object)GreateTagPrefixes.verticalGearbox, (Object)mat, (Object)gearboxEntry);
        }
        VERTICAL_GEARBOXES = VERTICAL_GEARBOXES_BUILDER.build();
    }
}

