/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTElements;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import electrolyte.greate.Greate;
import electrolyte.greate.content.gtceu.material.BeltProperty;
import electrolyte.greate.content.gtceu.material.CogwheelProperty;
import electrolyte.greate.content.gtceu.material.GreateMaterialFlags;
import electrolyte.greate.content.gtceu.material.GreatePropertyKeys;
import electrolyte.greate.content.gtceu.material.KineticProperty;
import electrolyte.greate.registry.GreateTagPrefixes;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class GreateMaterials {
    public static Material AndesiteAlloy;
    public static Material RoseQuartz;
    public static Material ChromaticCompound;
    public static Material RefinedRadiance;
    public static Material ShadowSteel;

    public static void register() {
        AndesiteAlloy = GreateMaterials.Builder("andesite_alloy").ingot().fluid().appendFlags((Collection)GTMaterials.STD_METAL, new MaterialFlag[]{MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_ROTOR}).color(14343114).secondaryColor(11257781).iconSet(MaterialIconSet.DULL).toolStats(ToolProperty.Builder.of((float)1.0f, (float)1.0f, (int)64, (int)0, (GTToolType[])new GTToolType[]{GTToolType.BUZZSAW}).build()).components(new Object[]{GTMaterials.Andesite, 1, GTMaterials.WroughtIron, 1}).buildAndRegister();
        RoseQuartz = GreateMaterials.Builder("rose_quartz").gem().color(16008305).secondaryColor(12988771).iconSet(MaterialIconSet.QUARTZ).flags(new MaterialFlag[]{MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.DISABLE_DECOMPOSITION}).components(new Object[]{GTMaterials.NetherQuartz, 1, GTMaterials.Redstone, 8}).buildAndRegister();
        ChromaticCompound = GreateMaterials.Builder("chromatic_compound").ingot().fluid().color(7621489).iconSet(MaterialIconSet.DULL).components(new Object[]{GTMaterials.Glowstone, 3, GTMaterials.Obsidian, 3, RoseQuartz, 1}).buildAndRegister();
        RefinedRadiance = GreateMaterials.Builder("refined_radiance").ingot().fluid().color(0xFFFFFF).secondaryColor(0xFFFFFF).iconSet(MaterialIconSet.METALLIC).appendFlags((Collection)GTMaterials.EXT2_METAL, new MaterialFlag[0]).buildAndRegister().setFormula(ChromaticCompound.getChemicalFormula() + GTElements.Ma.symbol());
        ShadowSteel = GreateMaterials.Builder("shadow_steel").ingot().fluid().color(0x35333C).iconSet(MaterialIconSet.METALLIC).appendFlags((Collection)GTMaterials.EXT2_METAL, new MaterialFlag[0]).buildAndRegister().setFormula(ChromaticCompound.getChemicalFormula() + GTElements.Sp.symbol());
        GTMaterials.WroughtIron.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_ROTOR});
        AndesiteAlloy.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(0, 8));
        GTMaterials.Steel.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(1, 32));
        GTMaterials.Aluminium.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(2, 128));
        GTMaterials.StainlessSteel.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(3, 512));
        GTMaterials.Titanium.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(4, 2048));
        GTMaterials.TungstenSteel.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(5, 8192));
        GTMaterials.RhodiumPlatedPalladium.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(6, 32768));
        GTMaterials.NaquadahAlloy.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(7, 131072));
        GTMaterials.Darmstadtium.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(8, 524288));
        GTMaterials.Neutronium.setProperty(GreatePropertyKeys.KINETIC, (IMaterialProperty)new KineticProperty(9, 0x200000));
        AndesiteAlloy.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.Wood));
        GTMaterials.Steel.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(AndesiteAlloy));
        GTMaterials.Aluminium.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.Steel));
        GTMaterials.StainlessSteel.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.Aluminium));
        GTMaterials.Titanium.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.StainlessSteel));
        GTMaterials.TungstenSteel.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.Titanium));
        GTMaterials.RhodiumPlatedPalladium.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.TungstenSteel));
        GTMaterials.NaquadahAlloy.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.RhodiumPlatedPalladium));
        GTMaterials.Darmstadtium.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.NaquadahAlloy));
        GTMaterials.Neutronium.setProperty(GreatePropertyKeys.COGWHEEL, (IMaterialProperty)new CogwheelProperty(GTMaterials.Darmstadtium));
        AndesiteAlloy.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, MaterialFlags.DISABLE_DECOMPOSITION});
        GTMaterials.WroughtIron.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Steel.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Aluminium.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_ROTOR, GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.StainlessSteel.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Titanium.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.TungstenSteel.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.RhodiumPlatedPalladium.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.NaquadahAlloy.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Darmstadtium.addFlags(new MaterialFlag[]{GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Neutronium.addFlags(new MaterialFlag[]{MaterialFlags.GENERATE_ROTOR, GreateMaterialFlags.GENERATE_WHISK, GreateMaterialFlags.GENERATE_ALLOY});
        GTMaterials.Darmstadtium.setProperty(PropertyKey.TOOL, (IMaterialProperty)ToolProperty.Builder.of((float)50.0f, (float)15.0f, (int)5120, (int)5, (GTToolType[])new GTToolType[]{GTToolType.BUZZSAW}).build());
        GTMaterials.RhodiumPlatedPalladium.setProperty(PropertyKey.TOOL, (IMaterialProperty)ToolProperty.Builder.of((float)35.0f, (float)10.0f, (int)2560, (int)4, (GTToolType[])new GTToolType[]{GTToolType.BUZZSAW}).build());
        GTMaterials.Rubber.setProperty(GreatePropertyKeys.BELT, (IMaterialProperty)new BeltProperty(List.of(AndesiteAlloy, GTMaterials.Steel)));
        GTMaterials.SiliconeRubber.setProperty(GreatePropertyKeys.BELT, (IMaterialProperty)new BeltProperty(List.of(GTMaterials.Aluminium, GTMaterials.StainlessSteel)));
        GTMaterials.Polyethylene.setProperty(GreatePropertyKeys.BELT, (IMaterialProperty)new BeltProperty(List.of(GTMaterials.Titanium, GTMaterials.TungstenSteel)));
        GTMaterials.Polytetrafluoroethylene.setProperty(GreatePropertyKeys.BELT, (IMaterialProperty)new BeltProperty(List.of(GTMaterials.RhodiumPlatedPalladium, GTMaterials.NaquadahAlloy)));
        GTMaterials.Polybenzimidazole.setProperty(GreatePropertyKeys.BELT, (IMaterialProperty)new BeltProperty(List.of(GTMaterials.Darmstadtium, GTMaterials.Neutronium)));
        GreateTagPrefixes.alloy.addSecondaryMaterial(new MaterialStack(GTMaterials.Andesite, 3628800L));
        GreateTagPrefixes.alloy.setIgnored(GTMaterials.WroughtIron, new Supplier[]{() -> AllItems.ANDESITE_ALLOY});
        TagPrefix.block.setIgnored(AndesiteAlloy, new Supplier[]{() -> AllBlocks.ANDESITE_ALLOY_BLOCK});
        TagPrefix.ingot.setIgnored(AndesiteAlloy, new Supplier[]{() -> AllItems.ANDESITE_ALLOY});
        TagPrefix.gem.setIgnored(RoseQuartz, new Supplier[]{() -> AllItems.ROSE_QUARTZ});
    }

    public static Material.Builder Builder(String id) {
        return new Material.Builder(Greate.id(id));
    }
}

