/*
 * Decompiled with CFR 0.152.
 */
package electrolyte.greate.registry;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import electrolyte.greate.Greate;
import electrolyte.greate.GreateValues;
import electrolyte.greate.registry.GreateMaterials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class GreatePartialModels {
    public static final PartialModel[] COGWHEEL_MODELS;
    public static final PartialModel[] COGWHEEL_SHAFTLESS_MODELS;
    public static final PartialModel[] LARGE_COGWHEEL_SHAFTLESS_MODELS;
    public static final PartialModel[] COGWHEEL_SHAFT_MODELS;
    public static final PartialModel[] POWERED_SHAFT_MODELS;
    public static final PartialModel[] SHAFT_HALF_MODELS;
    public static final PartialModel[] SHAFT_MODELS;
    public static final PartialModel[] CRUSHING_WHEEL_MODELS;
    public static final PartialModel[] MILLSTONE_INNER_MODELS;
    public static final Map<Material, List<PartialModel>> NEW_BELT_MODELS;
    public static final PartialModel RUBBER_BELT_ANDESITE_PULLEY;
    public static final PartialModel RUBBER_BELT_STEEL_PULLEY;
    public static final PartialModel RUBBER_BELT_START;
    public static final PartialModel RUBBER_BELT_MIDDLE;
    public static final PartialModel RUBBER_BELT_END;
    public static final PartialModel RUBBER_BELT_START_BOTTOM;
    public static final PartialModel RUBBER_BELT_MIDDLE_BOTTOM;
    public static final PartialModel RUBBER_BELT_END_BOTTOM;
    public static final PartialModel RUBBER_BELT_DIAGONAL_START;
    public static final PartialModel RUBBER_BELT_DIAGONAL_MIDDLE;
    public static final PartialModel RUBBER_BELT_DIAGONAL_END;
    public static final PartialModel SILICONE_RUBBER_BELT_ALUMINIUM_PULLEY;
    public static final PartialModel SILICONE_RUBBER_BELT_STAINLESS_STEEL_PULLEY;
    public static final PartialModel SILICONE_RUBBER_BELT_START;
    public static final PartialModel SILICONE_RUBBER_BELT_MIDDLE;
    public static final PartialModel SILICONE_RUBBER_BELT_END;
    public static final PartialModel SILICONE_RUBBER_BELT_START_BOTTOM;
    public static final PartialModel SILICONE_RUBBER_BELT_MIDDLE_BOTTOM;
    public static final PartialModel SILICONE_RUBBER_BELT_END_BOTTOM;
    public static final PartialModel SILICONE_RUBBER_BELT_DIAGONAL_START;
    public static final PartialModel SILICONE_RUBBER_BELT_DIAGONAL_MIDDLE;
    public static final PartialModel SILICONE_RUBBER_BELT_DIAGONAL_END;
    public static final PartialModel POLYETHYLENE_BELT_TITANIUM_PULLEY;
    public static final PartialModel POLYETHYLENE_BELT_TUNGSTENSTEEL_PULLEY;
    public static final PartialModel POLYETHYLENE_BELT_START;
    public static final PartialModel POLYETHYLENE_BELT_MIDDLE;
    public static final PartialModel POLYETHYLENE_BELT_END;
    public static final PartialModel POLYETHYLENE_BELT_START_BOTTOM;
    public static final PartialModel POLYETHYLENE_BELT_MIDDLE_BOTTOM;
    public static final PartialModel POLYETHYLENE_BELT_END_BOTTOM;
    public static final PartialModel POLYETHYLENE_BELT_DIAGONAL_START;
    public static final PartialModel POLYETHYLENE_BELT_DIAGONAL_MIDDLE;
    public static final PartialModel POLYETHYLENE_BELT_DIAGONAL_END;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_PALLADIUM_PULLEY;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_NAQUADAH_PULLEY;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_START;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_MIDDLE;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_END;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_START_BOTTOM;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_MIDDLE_BOTTOM;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_END_BOTTOM;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_START;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_MIDDLE;
    public static final PartialModel POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_END;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_DARMSTADTIUM_PULLEY;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_NEUTRONIUM_PULLEY;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_START;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_MIDDLE;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_END;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_START_BOTTOM;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_MIDDLE_BOTTOM;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_END_BOTTOM;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_DIAGONAL_START;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_DIAGONAL_MIDDLE;
    public static final PartialModel POLYBENZIMIDAZOLE_BELT_DIAGONAL_END;
    public static final PartialModel BELT_OVERLAY_DIAGONAL_START;
    public static final PartialModel BELT_OVERLAY_DIAGONAL_END;
    public static final PartialModel BELT_OVERLAY_DIAGONAL_MIDDLE;
    public static final PartialModel BELT_OVERLAY_START_BOTTOM;
    public static final PartialModel BELT_OVERLAY_END_BOTTOM;
    public static final PartialModel BELT_OVERLAY_MIDDLE_BOTTOM;
    public static final PartialModel BELT_OVERLAY_START;
    public static final PartialModel BELT_OVERLAY_END;
    public static final PartialModel BELT_OVERLAY_MIDDLE;
    public static final PartialModel BELT_CASING_DIAGONAL_START;
    public static final PartialModel BELT_CASING_DIAGONAL_END;
    public static final PartialModel BELT_CASING_DIAGONAL_MIDDLE;
    public static final PartialModel BELT_CASING_SIDEWAYS_START;
    public static final PartialModel BELT_CASING_SIDEWAYS_END;
    public static final PartialModel BELT_CASING_SIDEWAYS_MIDDLE;
    public static final PartialModel BELT_CASING_SIDEWAYS_PULLEY;
    public static final PartialModel BELT_CASING_HORIZONTAL_START;
    public static final PartialModel BELT_CASING_HORIZONTAL_END;
    public static final PartialModel BELT_CASING_HORIZONTAL_MIDDLE;
    public static final PartialModel BELT_CASING_HORIZONTAL_PULLEY;
    public static final PartialModel[] MECHANICAL_PRESS_HEAD_MODELS;
    public static final PartialModel[] MECHANICAL_MIXER_HEAD_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_HORIZONTAL_ACTIVE_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_HORIZONTAL_REVERSED_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_HORIZONTAL_INACTIVE_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_VERTICAL_ACTIVE_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_VERTICAL_REVERSED_MODELS;
    public static final PartialModel[] MECHANICAL_SAW_BLADE_VERTICAL_INACTIVE_MODELS;
    public static final PartialModel[] MECHANICAL_PUMP_COG_MODELS;
    public static final PartialModel[] FAN_INNER_MODELS;

    private static PartialModel belt(Material beltMaterial, BeltPart beltPart) {
        String beltpartName = beltPart.name().toLowerCase();
        PartialModel partialModel = GreatePartialModels.materialBlock(beltMaterial, "_belt_" + beltpartName);
        List partialModels = NEW_BELT_MODELS.getOrDefault(beltMaterial, new ArrayList());
        partialModels.add(partialModel);
        NEW_BELT_MODELS.put(beltMaterial, partialModels);
        return partialModel;
    }

    private static PartialModel beltCasing(BeltPart beltPart) {
        return GreatePartialModels.block("belt_casing_" + beltPart.name().toLowerCase());
    }

    private static PartialModel beltPulley(Material beltMaterial, Material pulleyMaterial) {
        PartialModel partialModel = GreatePartialModels.materialBlock(beltMaterial, "_belt_" + pulleyMaterial.getName() + "_pulley");
        List partialModels = NEW_BELT_MODELS.getOrDefault(beltMaterial, new ArrayList());
        partialModels.add(partialModel);
        NEW_BELT_MODELS.put(beltMaterial, partialModels);
        return partialModel;
    }

    private static PartialModel materialBlock(String prefix, Material material, String postfix) {
        return GreatePartialModels.block(prefix + material.getName() + postfix);
    }

    private static PartialModel materialBlock(Material material, String postfix) {
        return GreatePartialModels.block(material.getName() + postfix);
    }

    private static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)Greate.id("block/" + path));
    }

    public static void register() {
    }

    static {
        int tier;
        COGWHEEL_MODELS = new PartialModel[10];
        COGWHEEL_SHAFTLESS_MODELS = new PartialModel[10];
        LARGE_COGWHEEL_SHAFTLESS_MODELS = new PartialModel[10];
        COGWHEEL_SHAFT_MODELS = new PartialModel[10];
        POWERED_SHAFT_MODELS = new PartialModel[10];
        SHAFT_HALF_MODELS = new PartialModel[10];
        SHAFT_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            Material tierMaterial = GreateValues.TM[tier];
            GreatePartialModels.COGWHEEL_MODELS[tier] = GreatePartialModels.materialBlock(tierMaterial, "_cogwheel");
            GreatePartialModels.COGWHEEL_SHAFTLESS_MODELS[tier] = GreatePartialModels.materialBlock(tierMaterial, "_cogwheel_shaftless");
            GreatePartialModels.LARGE_COGWHEEL_SHAFTLESS_MODELS[tier] = GreatePartialModels.materialBlock("large_", tierMaterial, "_cogwheel_shaftless");
            GreatePartialModels.COGWHEEL_SHAFT_MODELS[tier] = GreatePartialModels.materialBlock(tierMaterial, "_cogwheel_shaft");
            GreatePartialModels.POWERED_SHAFT_MODELS[tier] = GreatePartialModels.materialBlock("powered_", tierMaterial, "_shaft");
            GreatePartialModels.SHAFT_HALF_MODELS[tier] = GreatePartialModels.materialBlock(tierMaterial, "_shaft_half");
            GreatePartialModels.SHAFT_MODELS[tier] = GreatePartialModels.materialBlock(tierMaterial, "_shaft");
        }
        CRUSHING_WHEEL_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.CRUSHING_WHEEL_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_crushing_wheel");
        }
        MILLSTONE_INNER_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.MILLSTONE_INNER_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_millstone_inner");
        }
        NEW_BELT_MODELS = new HashMap<Material, List<PartialModel>>();
        RUBBER_BELT_ANDESITE_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Rubber, GreateMaterials.AndesiteAlloy);
        RUBBER_BELT_STEEL_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Rubber, GTMaterials.Steel);
        RUBBER_BELT_START = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.START);
        RUBBER_BELT_MIDDLE = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.MIDDLE);
        RUBBER_BELT_END = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.END);
        RUBBER_BELT_START_BOTTOM = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.START_BOTTOM);
        RUBBER_BELT_MIDDLE_BOTTOM = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.MIDDLE_BOTTOM);
        RUBBER_BELT_END_BOTTOM = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.END_BOTTOM);
        RUBBER_BELT_DIAGONAL_START = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.DIAGONAL_START);
        RUBBER_BELT_DIAGONAL_MIDDLE = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.DIAGONAL_MIDDLE);
        RUBBER_BELT_DIAGONAL_END = GreatePartialModels.belt(GTMaterials.Rubber, BeltPart.DIAGONAL_END);
        SILICONE_RUBBER_BELT_ALUMINIUM_PULLEY = GreatePartialModels.beltPulley(GTMaterials.SiliconeRubber, GTMaterials.Aluminium);
        SILICONE_RUBBER_BELT_STAINLESS_STEEL_PULLEY = GreatePartialModels.beltPulley(GTMaterials.SiliconeRubber, GTMaterials.StainlessSteel);
        SILICONE_RUBBER_BELT_START = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.START);
        SILICONE_RUBBER_BELT_MIDDLE = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.MIDDLE);
        SILICONE_RUBBER_BELT_END = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.END);
        SILICONE_RUBBER_BELT_START_BOTTOM = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.START_BOTTOM);
        SILICONE_RUBBER_BELT_MIDDLE_BOTTOM = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.MIDDLE_BOTTOM);
        SILICONE_RUBBER_BELT_END_BOTTOM = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.END_BOTTOM);
        SILICONE_RUBBER_BELT_DIAGONAL_START = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.DIAGONAL_START);
        SILICONE_RUBBER_BELT_DIAGONAL_MIDDLE = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.DIAGONAL_MIDDLE);
        SILICONE_RUBBER_BELT_DIAGONAL_END = GreatePartialModels.belt(GTMaterials.SiliconeRubber, BeltPart.DIAGONAL_END);
        POLYETHYLENE_BELT_TITANIUM_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polyethylene, GTMaterials.Titanium);
        POLYETHYLENE_BELT_TUNGSTENSTEEL_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polyethylene, GTMaterials.TungstenSteel);
        POLYETHYLENE_BELT_START = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.START);
        POLYETHYLENE_BELT_MIDDLE = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.MIDDLE);
        POLYETHYLENE_BELT_END = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.END);
        POLYETHYLENE_BELT_START_BOTTOM = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.START_BOTTOM);
        POLYETHYLENE_BELT_MIDDLE_BOTTOM = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.MIDDLE_BOTTOM);
        POLYETHYLENE_BELT_END_BOTTOM = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.END_BOTTOM);
        POLYETHYLENE_BELT_DIAGONAL_START = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.DIAGONAL_START);
        POLYETHYLENE_BELT_DIAGONAL_MIDDLE = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.DIAGONAL_MIDDLE);
        POLYETHYLENE_BELT_DIAGONAL_END = GreatePartialModels.belt(GTMaterials.Polyethylene, BeltPart.DIAGONAL_END);
        POLYTETRAFLUOROETHYLENE_BELT_PALLADIUM_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polytetrafluoroethylene, GTMaterials.RhodiumPlatedPalladium);
        POLYTETRAFLUOROETHYLENE_BELT_NAQUADAH_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polytetrafluoroethylene, GTMaterials.NaquadahAlloy);
        POLYTETRAFLUOROETHYLENE_BELT_START = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.START);
        POLYTETRAFLUOROETHYLENE_BELT_MIDDLE = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.MIDDLE);
        POLYTETRAFLUOROETHYLENE_BELT_END = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.END);
        POLYTETRAFLUOROETHYLENE_BELT_START_BOTTOM = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.START_BOTTOM);
        POLYTETRAFLUOROETHYLENE_BELT_MIDDLE_BOTTOM = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.MIDDLE_BOTTOM);
        POLYTETRAFLUOROETHYLENE_BELT_END_BOTTOM = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.END_BOTTOM);
        POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_START = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.DIAGONAL_START);
        POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_MIDDLE = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.DIAGONAL_MIDDLE);
        POLYTETRAFLUOROETHYLENE_BELT_DIAGONAL_END = GreatePartialModels.belt(GTMaterials.Polytetrafluoroethylene, BeltPart.DIAGONAL_END);
        POLYBENZIMIDAZOLE_BELT_DARMSTADTIUM_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polybenzimidazole, GTMaterials.Darmstadtium);
        POLYBENZIMIDAZOLE_BELT_NEUTRONIUM_PULLEY = GreatePartialModels.beltPulley(GTMaterials.Polybenzimidazole, GTMaterials.Neutronium);
        POLYBENZIMIDAZOLE_BELT_START = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.START);
        POLYBENZIMIDAZOLE_BELT_MIDDLE = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.MIDDLE);
        POLYBENZIMIDAZOLE_BELT_END = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.END);
        POLYBENZIMIDAZOLE_BELT_START_BOTTOM = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.START_BOTTOM);
        POLYBENZIMIDAZOLE_BELT_MIDDLE_BOTTOM = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.MIDDLE_BOTTOM);
        POLYBENZIMIDAZOLE_BELT_END_BOTTOM = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.END_BOTTOM);
        POLYBENZIMIDAZOLE_BELT_DIAGONAL_START = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.DIAGONAL_START);
        POLYBENZIMIDAZOLE_BELT_DIAGONAL_MIDDLE = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.DIAGONAL_MIDDLE);
        POLYBENZIMIDAZOLE_BELT_DIAGONAL_END = GreatePartialModels.belt(GTMaterials.Polybenzimidazole, BeltPart.DIAGONAL_END);
        BELT_OVERLAY_DIAGONAL_START = GreatePartialModels.block("belt_overlay_diagonal_start");
        BELT_OVERLAY_DIAGONAL_END = GreatePartialModels.block("belt_overlay_diagonal_end");
        BELT_OVERLAY_DIAGONAL_MIDDLE = GreatePartialModels.block("belt_overlay_diagonal_middle");
        BELT_OVERLAY_START_BOTTOM = GreatePartialModels.block("belt_overlay_start_bottom");
        BELT_OVERLAY_END_BOTTOM = GreatePartialModels.block("belt_overlay_end_bottom");
        BELT_OVERLAY_MIDDLE_BOTTOM = GreatePartialModels.block("belt_overlay_middle_bottom");
        BELT_OVERLAY_START = GreatePartialModels.block("belt_overlay_start");
        BELT_OVERLAY_END = GreatePartialModels.block("belt_overlay_end");
        BELT_OVERLAY_MIDDLE = GreatePartialModels.block("belt_overlay_middle");
        BELT_CASING_DIAGONAL_START = GreatePartialModels.beltCasing(BeltPart.DIAGONAL_START);
        BELT_CASING_DIAGONAL_END = GreatePartialModels.beltCasing(BeltPart.DIAGONAL_END);
        BELT_CASING_DIAGONAL_MIDDLE = GreatePartialModels.beltCasing(BeltPart.DIAGONAL_MIDDLE);
        BELT_CASING_SIDEWAYS_START = GreatePartialModels.beltCasing(BeltPart.SIDEWAYS_START);
        BELT_CASING_SIDEWAYS_END = GreatePartialModels.beltCasing(BeltPart.SIDEWAYS_END);
        BELT_CASING_SIDEWAYS_MIDDLE = GreatePartialModels.beltCasing(BeltPart.SIDEWAYS_MIDDLE);
        BELT_CASING_SIDEWAYS_PULLEY = GreatePartialModels.beltCasing(BeltPart.SIDEWAYS_PULLEY);
        BELT_CASING_HORIZONTAL_START = GreatePartialModels.beltCasing(BeltPart.HORIZONTAL_START);
        BELT_CASING_HORIZONTAL_END = GreatePartialModels.beltCasing(BeltPart.HORIZONTAL_END);
        BELT_CASING_HORIZONTAL_MIDDLE = GreatePartialModels.beltCasing(BeltPart.HORIZONTAL_MIDDLE);
        BELT_CASING_HORIZONTAL_PULLEY = GreatePartialModels.beltCasing(BeltPart.HORIZONTAL_PULLEY);
        MECHANICAL_PRESS_HEAD_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.MECHANICAL_PRESS_HEAD_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_press_head");
        }
        MECHANICAL_MIXER_HEAD_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.MECHANICAL_MIXER_HEAD_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_mixer_head");
        }
        MECHANICAL_SAW_BLADE_HORIZONTAL_ACTIVE_MODELS = new PartialModel[10];
        MECHANICAL_SAW_BLADE_HORIZONTAL_REVERSED_MODELS = new PartialModel[10];
        MECHANICAL_SAW_BLADE_HORIZONTAL_INACTIVE_MODELS = new PartialModel[10];
        MECHANICAL_SAW_BLADE_VERTICAL_ACTIVE_MODELS = new PartialModel[10];
        MECHANICAL_SAW_BLADE_VERTICAL_REVERSED_MODELS = new PartialModel[10];
        MECHANICAL_SAW_BLADE_VERTICAL_INACTIVE_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_ACTIVE_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_horizontal_active");
            GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_REVERSED_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_horizontal_reversed");
            GreatePartialModels.MECHANICAL_SAW_BLADE_HORIZONTAL_INACTIVE_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_horizontal_inactive");
            GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_ACTIVE_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_vertical_active");
            GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_REVERSED_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_vertical_reversed");
            GreatePartialModels.MECHANICAL_SAW_BLADE_VERTICAL_INACTIVE_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_saw_blade_vertical_inactive");
        }
        MECHANICAL_PUMP_COG_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.MECHANICAL_PUMP_COG_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_mechanical_pump_cog");
        }
        FAN_INNER_MODELS = new PartialModel[10];
        for (tier = 0; tier < GreateValues.TM.length; ++tier) {
            GreatePartialModels.FAN_INNER_MODELS[tier] = GreatePartialModels.materialBlock(GreateValues.TM[tier], "_encased_fan_propeller");
        }
    }

    public static enum BeltPart {
        PULLEY,
        START,
        END,
        MIDDLE,
        START_BOTTOM,
        MIDDLE_BOTTOM,
        END_BOTTOM,
        DIAGONAL_START,
        DIAGONAL_MIDDLE,
        DIAGONAL_END,
        SIDEWAYS_START,
        SIDEWAYS_MIDDLE,
        SIDEWAYS_END,
        SIDEWAYS_PULLEY,
        HORIZONTAL_END,
        HORIZONTAL_MIDDLE,
        HORIZONTAL_PULLEY,
        HORIZONTAL_START;

    }
}

