/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.pineapple.common;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemDrinkable
extends Item {
    public ItemDrinkable(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    @Nonnull
    public ItemStack finishUsingItem(ItemStack itemStack, Level world, LivingEntity entityLiving) {
        super.finishUsingItem(itemStack, world, entityLiving);
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (itemStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (!player.getAbilities().instabuild && !player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                player.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
            }
        }
        return itemStack;
    }
}

