/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.pineapple.common;

import club.someoneice.pineapple.init.ItemList;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemPineappleMaceHand
extends SwordItem {
    private static final Tier tier = new Tier(){

        public int getUses() {
            return 64;
        }

        public float getSpeed() {
            return 1.6f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pineapple_delight", (String)"pineapple"));
        }

        public int getEnchantmentValue() {
            return 8;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemList.PINEAPPLE.get(), (ItemLike)ItemList.PINEAPPLE_SIDE.get()});
        }
    };

    public ItemPineappleMaceHand() {
        super(tier, new Item.Properties().fireResistant().attributes(SwordItem.createAttributes((Tier)tier, (int)5, (float)-2.4f)).food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).build()));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isCreative()) {
            stack.hurtAndBreak(4, livingEntity, EquipmentSlot.MAINHAND);
        }
        level.gameEvent((Holder)GameEvent.EAT, livingEntity.position(), GameEvent.Context.of((Entity)livingEntity));
        return super.finishUsingItem(stack, level, livingEntity);
    }
}

