/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.pineapple.common;

import club.someoneice.pineapple.PineappleMain;
import club.someoneice.pineapple.init.BlockList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class BlockPineappleCrop
extends CropBlock {
    public BlockPineappleCrop() {
        super(BlockBehaviour.Properties.of().noCollission().noOcclusion().sound(SoundType.CROP).randomTicks().instabreak());
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!PineappleMain.SEASON_INSTALL) {
            super.randomTick(state, world, pos, random);
            return;
        }
        Season season = SeasonHelper.getSeasonState((Level)world).getSeason();
        if (season != Season.SPRING && season != Season.SUMMER) {
            return;
        }
        int age = this.getAge(state);
        if (age < this.getMaxAge() - 1 || season == Season.SUMMER) {
            super.randomTick(state, world, pos, random);
        }
        if (age != this.getMaxAge() || world.getMoonPhase() != 1) {
            return;
        }
        float f = BlockPineappleCrop.getGrowthSpeed((BlockState)state, (BlockGetter)world, (BlockPos)pos);
        if (!CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
            return;
        }
        world.setBlock(pos, ((Block)BlockList.HUGE_PINEAPPLE.get()).defaultBlockState(), 2);
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)BlockList.PINEAPPLE_CROP_ITEM.get();
    }
}

