/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.glowtone.render_type.impl;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.frozenblock.glowtone.GlowtoneConstants;
import net.frozenblock.glowtone.render_type.impl.BlockRenderTypeOverwrite;
import net.minecraft.class_11515;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class BlockRenderTypeOverwriteManager
implements SimpleResourceReloadListener<RenderTypeLoader> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Block Render Type Overwrite Manager");
    private static final String DIRECTORY = "glowtone_block_render_type_overwrites";
    public static final BlockRenderTypeOverwriteManager INSTANCE = new BlockRenderTypeOverwriteManager();
    private final List<BlockRenderTypeOverwrite> overwrites = new ArrayList<BlockRenderTypeOverwrite>();

    public void addFinalizedOverwrite(BlockRenderTypeOverwrite overwrite) {
        this.overwrites.add(overwrite);
    }

    public CompletableFuture<RenderTypeLoader> load(class_3300 manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> new RenderTypeLoader(manager), executor);
    }

    public CompletableFuture<Void> apply(@NotNull RenderTypeLoader prepared, class_3300 manager, Executor executor) {
        this.overwrites.clear();
        prepared.getOverwrites().forEach(this::addFinalizedOverwrite);
        this.applyOverwrites();
        return CompletableFuture.runAsync(() -> {});
    }

    private void applyOverwrites() {
        this.overwrites.forEach(overwrite -> BlockRenderLayerMap.putBlock((class_2248)overwrite.getBlock(), (class_11515)overwrite.getRenderType()));
    }

    @NotNull
    public class_2960 getFabricId() {
        return GlowtoneConstants.id("block_render_type_overwrites");
    }

    public static class RenderTypeLoader {
        private static final String REPLACEMENT_DIRECTORY = "glowtone_block_render_type_overwrites/";
        private final class_3300 manager;
        private final List<BlockRenderTypeOverwrite> parsedOverwrites = new ArrayList<BlockRenderTypeOverwrite>();

        public RenderTypeLoader(class_3300 manager) {
            this.manager = manager;
            this.loadRenderTypeOverwrites();
        }

        private void loadRenderTypeOverwrites() {
            Map resources = this.manager.method_14488(BlockRenderTypeOverwriteManager.DIRECTORY, id -> id.method_12832().endsWith(".json"));
            Set entrySet = resources.entrySet();
            for (Map.Entry entry : entrySet) {
                this.addOverwrite((class_2960)entry.getKey(), (class_3298)entry.getValue());
            }
        }

        private void addOverwrite(class_2960 location, @NotNull class_3298 resource) {
            BufferedReader reader;
            try {
                reader = resource.method_43039();
            }
            catch (IOException e) {
                LOGGER.error("Unable to open BufferedReader for file: `{}`", (Object)location);
                return;
            }
            JsonObject json = class_3518.method_15255((Reader)reader);
            DataResult dataResult = BlockRenderTypeOverwrite.RenderTypeOverwriteHolder.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            dataResult.resultOrPartial(string -> LOGGER.error("Failed to parse render type override for file: '{}'", (Object)location)).ifPresent(overwrite -> {
                class_2960 blockName = class_2960.method_60655((String)location.method_12836(), (String)location.method_12832().replace(".json", "").replaceFirst(REPLACEMENT_DIRECTORY, ""));
                class_2248 block = class_7923.field_41175.method_17966(blockName).orElse(null);
                if (block != null) {
                    this.parsedOverwrites.add(new BlockRenderTypeOverwrite(block, ((BlockRenderTypeOverwrite.RenderTypeOverwriteHolder)overwrite.getFirst()).renderTypeOverwrite()));
                } else {
                    LOGGER.error("Failed to find block of name: '{}'", (Object)blockName);
                }
            });
        }

        public List<BlockRenderTypeOverwrite> getOverwrites() {
            return this.parsedOverwrites;
        }
    }
}

