/*
 * Decompiled with CFR 0.152.
 */
package com.shadowplayer;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shadowplayer
implements ModInitializer {
    public static final String MOD_ID = "shadowplayer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"shadowplayer");
    private static final String CMD_SHADOW = "player %s shadow";
    private static final String CMD_GAMEMODE = "gamemode spectator %s";

    public void onInitialize() {
        LOGGER.info("Shadow Player Mod has been initialized!");
        this.registerPlayerEvents();
    }

    private void registerPlayerEvents() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            String playerName = player.method_7334().getName();
            this.handlePlayerDisconnect(server, player);
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_1657) {
                this.handlePlayerDeath((class_1657)entity);
            }
        });
    }

    private void handlePlayerDisconnect(MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            try {
                this.executeCommand(server, String.format(CMD_SHADOW, player.method_7334().getName()));
            }
            catch (Exception e) {
                LOGGER.error("Error creating shadow player: {}", (Object)e.getMessage());
            }
        });
    }

    private void handlePlayerDeath(class_1657 player) {
        MinecraftServer server = player.method_5682();
        if (server.method_3847(player.method_37908().method_27983()).method_8401().method_152()) {
            try {
                this.executeCommand(server, String.format(CMD_GAMEMODE, player.method_7334().getName()));
            }
            catch (Exception e) {
                LOGGER.error("Error setting gamemode to spectator: {}", (Object)e.getMessage());
            }
        }
    }

    private void executeCommand(MinecraftServer server, String command) {
        server.method_3734().method_44252(server.method_3739(), command);
    }
}

