/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder;

import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.potionstudios.wayfinder.Wayfinder;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public interface PlatformHandler {
    public static final PlatformHandler PLATFORM_HANDLER = PlatformHandler.load(PlatformHandler.class);

    public Path configPath();

    default public boolean hasPermission(@NotNull CommandSourceStack sourceStack, @NotNull String permission) {
        return sourceStack.hasPermission(4);
    }

    default public Supplier<SpawnEggItem> createSpawnEgg(Supplier<EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor) {
        return () -> new SpawnEggItem((EntityType)entity.get(), backgroundColor, highlightColor, new Item.Properties());
    }

    public <T> Supplier<T> register(Registry<? super T> var1, String var2, Supplier<T> var3);

    public <T> Supplier<Holder.Reference<T>> registerForHolder(Registry<T> var1, String var2, Supplier<T> var3);

    default public boolean hasWayfinder(Player player) {
        return !this.getWayfinder(player).equals(Util.NIL_UUID);
    }

    public void setWayfinder(Player var1, UUID var2);

    public UUID getWayfinder(Player var1);

    public int getWayfinderDeaths(Player var1);

    public void incrementWayfinderDeaths(Player var1);

    public void resetWayfinderDeaths(Player var1);

    public void increment3kJourneys(Player var1);

    public int get3kJourneys(Player var1);

    public void sendToPlayer(MultiloaderPacket var1, Player var2);

    public void sendToServer(MultiloaderPacket var1);

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Wayfinder.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

