/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;

class WayfinderRemoveCommand {
    WayfinderRemoveCommand() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder removeCommand = LiteralArgumentBuilder.literal((String)"remove");
        removeCommand.requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "wayfinder.commands.remove"));
        ((LiteralArgumentBuilder)removeCommand.executes(WayfinderRemoveCommand::removeWayfinder)).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(WayfinderRemoveCommand::removeSelectedPlayerWayfinder)).then(RequiredArgumentBuilder.argument((String)"kill", (ArgumentType)BoolArgumentType.bool()).executes(WayfinderRemoveCommand::removeSelectedPlayerWayfinderKill)));
        return removeCommand;
    }

    private static int removeWayfinder(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return WayfinderRemoveCommand.removeWayfinder(((CommandSourceStack)context.getSource()).getPlayerOrException(), context);
    }

    private static int removeSelectedPlayerWayfinder(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return WayfinderRemoveCommand.removeWayfinder(EntityArgument.getPlayer(context, (String)"player"), context);
    }

    private static int removeSelectedPlayerWayfinderKill(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        if (BoolArgumentType.getBool(context, (String)"kill")) {
            if (PlatformHandler.PLATFORM_HANDLER.hasWayfinder((Player)player)) {
                UUID wayfinderId = PlatformHandler.PLATFORM_HANDLER.getWayfinder((Player)player);
                PlatformHandler.PLATFORM_HANDLER.setWayfinder((Player)player, Util.NIL_UUID);
                Entity entity = player.serverLevel().getEntity(wayfinderId);
                if (entity instanceof WayfinderEntity) {
                    WayfinderEntity wayfinder = (WayfinderEntity)entity;
                    wayfinder.discard();
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.remove.kill.success", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.remove.success", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN), false);
                return 1;
            }
        } else {
            return WayfinderRemoveCommand.removeWayfinder(player, context);
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.remove.fail", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int removeWayfinder(ServerPlayer player, CommandContext<CommandSourceStack> context) {
        if (PlatformHandler.PLATFORM_HANDLER.hasWayfinder((Player)player)) {
            UUID wayfinderId = PlatformHandler.PLATFORM_HANDLER.getWayfinder((Player)player);
            PlatformHandler.PLATFORM_HANDLER.setWayfinder((Player)player, Util.NIL_UUID);
            Entity entity = player.serverLevel().getEntity(wayfinderId);
            if (entity instanceof WayfinderEntity) {
                WayfinderEntity wayfinder = (WayfinderEntity)entity;
                wayfinder.setOwnerUUID(null);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"wayfinder.commands.remove.success", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"wayfinder.commands.remove.fail", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED));
        return 0;
    }
}

