/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.commands.WayfinderCommands;
import net.potionstudios.wayfinder.neoforge.NeoForgePlatformHandler;
import net.potionstudios.wayfinder.neoforge.data.WayfinderNeoForgeAttachmentData;
import net.potionstudios.wayfinder.network.protocol.WayfinderNetworking;
import net.potionstudios.wayfinder.world.item.WayfinderItems;
import net.potionstudios.wayfinder.world.level.block.WayfinderBlocks;

@Mod(value="wayfinder")
public class WayfinderNeoForge {
    public WayfinderNeoForge(IEventBus eventBus) {
        IEventBus EVENT_BUS = NeoForge.EVENT_BUS;
        Wayfinder.init();
        NeoForgePlatformHandler.register(eventBus);
        eventBus.addListener(event -> Wayfinder.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        EVENT_BUS.addListener(event -> WayfinderCommands.register(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0)));
        eventBus.addListener(event -> {
            if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)WayfinderItems.WAYFINDER_SPAWN_EGG.get());
            } else if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
                event.accept((ItemLike)WayfinderBlocks.WAYFINER_HEART.get());
            } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                event.accept((ItemLike)WayfinderItems.MUSIC_DISC_SWEET_DREAMS.get());
            }
        });
        EVENT_BUS.addListener(event -> Wayfinder.onEntityLoad(event.getEntity()));
        eventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar("wayfinder").executesOn(HandlerThread.NETWORK);
            WayfinderNetworking.registerS2CPackets((type, codec) -> registrar.playToClient(type, codec, (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))));
            WayfinderNetworking.registerC2SPackets((type, codec) -> registrar.playToServer(type, codec, (packet, context) -> packet.receiveMessage(context.player(), arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))));
        });
        WayfinderNeoForgeAttachmentData.init(eventBus);
    }
}

