/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.neoforge.data;

import com.mojang.serialization.Codec;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.potionstudios.wayfinder.Wayfinder;

public class WayfinderNeoForgeAttachmentData {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"wayfinder");
    private static final Supplier<AttachmentType<UUID>> WAYFINDER = ATTACHMENT_TYPES.register("wayfinder", () -> AttachmentType.builder(() -> Util.NIL_UUID).serialize(UUIDUtil.CODEC).copyOnDeath().build());
    private static final Supplier<AttachmentType<Integer>> WAYFINDER_DEATHS = ATTACHMENT_TYPES.register("wayfinder_deaths", () -> AttachmentType.builder(() -> 0).serialize((Codec)Codec.INT).copyOnDeath().build());
    private static final Supplier<AttachmentType<Integer>> THREE_K_JOUNEYS = ATTACHMENT_TYPES.register("3k_journeys", () -> AttachmentType.builder(() -> 0).serialize((Codec)Codec.INT).copyOnDeath().build());

    public static void setWayfinder(Player player, UUID wayfinder) {
        player.setData(WAYFINDER, (Object)wayfinder);
    }

    public static UUID getWayfinder(Player player) {
        return (UUID)player.getData(WAYFINDER);
    }

    public static int getWayfinderDeaths(Player player) {
        return (Integer)player.getData(WAYFINDER_DEATHS);
    }

    public static void resetWayfinderDeaths(Player player) {
        player.setData(WAYFINDER_DEATHS, (Object)0);
    }

    public static void incrementWayfinderDeaths(Player player) {
        player.setData(WAYFINDER_DEATHS, (Object)(WayfinderNeoForgeAttachmentData.getWayfinderDeaths(player) + 1));
    }

    public static int get3kJourneys(Player player) {
        return (Integer)player.getData(THREE_K_JOUNEYS);
    }

    public static void increment3kJourneys(Player player) {
        player.setData(THREE_K_JOUNEYS, (Object)(WayfinderNeoForgeAttachmentData.get3kJourneys(player) + 1));
    }

    public static void init(IEventBus eventBus) {
        Wayfinder.LOGGER.info("Registering Wayfinder NeoForge Attachment Data");
        ATTACHMENT_TYPES.register(eventBus);
    }
}

