/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.network.packets;

import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public record WayfinderSitPacket(boolean sit) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<WayfinderSitPacket> TYPE = new CustomPacketPayload.Type(Wayfinder.id("sit"));
    public static final StreamCodec<FriendlyByteBuf, WayfinderSitPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, WayfinderSitPacket::sit, WayfinderSitPacket::new);

    public void receiveMessage(@Nullable Player player, Consumer<Runnable> consumer) {
        consumer.accept(() -> {
            Entity entity = player.getServer().getLevel(player.getCommandSenderWorld().dimension()).getEntity(PlatformHandler.PLATFORM_HANDLER.getWayfinder(player));
            if (entity instanceof WayfinderEntity) {
                WayfinderEntity wayfinder = (WayfinderEntity)entity;
                if (this.sit) {
                    wayfinder.sit();
                } else {
                    wayfinder.stand();
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

