/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.potionstudios.wayfinder.world.entity.wayfinder.WayfinderEntity;
import org.jetbrains.annotations.Nullable;

public class FollowOwnerGoal
extends Goal {
    private final WayfinderEntity wayfinder;
    @Nullable
    private LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float startDistance;
    private final float stopDistance;

    public FollowOwnerGoal(WayfinderEntity wayfinder, double speedModifier, float startDistance, float stopDistance) {
        this.wayfinder = wayfinder;
        this.speedModifier = speedModifier;
        this.navigation = wayfinder.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.wayfinder.getOwner();
        if (livingEntity == null) {
            return false;
        }
        if (this.wayfinder.unableToMoveToOwner()) {
            return false;
        }
        if (this.wayfinder.distanceToSqr((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return !this.wayfinder.unableToMoveToOwner() && !(this.wayfinder.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
    }

    public void tick() {
        boolean bl = this.wayfinder.shouldTryTeleportToOwner();
        if (!bl) {
            this.wayfinder.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.wayfinder.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (bl) {
                this.wayfinder.tryToTeleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

