/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.wayfinder.world.entity.wayfinder;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.potionstudios.wayfinder.PlatformHandler;
import net.potionstudios.wayfinder.Wayfinder;
import net.potionstudios.wayfinder.advancements.critereon.WayfinderCriteriaTriggers;
import net.potionstudios.wayfinder.network.packets.WayfinderCloseScreenPacket;
import net.potionstudios.wayfinder.network.packets.WayfinderOpenScreenPacket;
import net.potionstudios.wayfinder.sounds.WayfinderSounds;
import net.potionstudios.wayfinder.tags.WayfinderBiomeTags;
import net.potionstudios.wayfinder.world.entity.WayfinderEntityType;
import net.potionstudios.wayfinder.world.entity.ai.control.WayfinderMoveControl;
import net.potionstudios.wayfinder.world.entity.ai.goal.FollowOwnerGoal;
import net.potionstudios.wayfinder.world.entity.ai.goal.GoToPosGoal;
import net.potionstudios.wayfinder.world.entity.ai.goal.ScaredWayfinderGoal;
import net.potionstudios.wayfinder.world.entity.ai.goal.ShieldRegenGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WayfinderEntity
extends PathfinderMob
implements GeoEntity,
OwnableEntity,
VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_1 = RawAnimation.begin().then("idle1", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_2 = RawAnimation.begin().then("idle2", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_3 = RawAnimation.begin().then("idle3", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_4 = RawAnimation.begin().then("idle4", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_5 = RawAnimation.begin().then("idle5", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DEATH = RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private static final RawAnimation SEARCHING_START = RawAnimation.begin().thenPlay("searching_start");
    private static final RawAnimation SEARCHING_END = RawAnimation.begin().then("searching_end", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SEARCHING_LOOP = RawAnimation.begin().thenLoop("searching_loop");
    private static final RawAnimation NO = RawAnimation.begin().then("no", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SIT_IDLE_1 = RawAnimation.begin().thenLoop("sit_idle1");
    private static final RawAnimation SIT_IDLE_2 = RawAnimation.begin().thenLoop("sit_idle2");
    private static final RawAnimation SIT_IDLE_3 = RawAnimation.begin().thenLoop("sit_idle3");
    private static final RawAnimation SIT_IDLE_4 = RawAnimation.begin().thenLoop("sit_idle4");
    private static final RawAnimation SCARED = RawAnimation.begin().thenLoop("scared");
    private static final EntityDataAccessor<Optional<BlockPos>> BLOCK_POS = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> DATA_SCARED = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SITTING = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_SHIELD = SynchedEntityData.defineId(WayfinderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float phaseOffset;
    private int foundBiomeTick;
    private int completedJourneys;

    public WayfinderEntity(Level level, Player owner) {
        this(WayfinderEntityType.WAYFINDER.get(), level);
        this.setOwner(owner);
    }

    public WayfinderEntity(EntityType<? extends WayfinderEntity> entityType, Level level) {
        super(entityType, level);
        this.foundBiomeTick = -20 * Wayfinder.CONFIG.wayfinder.COOLDOWN.value();
        this.phaseOffset = this.random.nextFloat() * ((float)Math.PI * 2);
        this.moveControl = new WayfinderMoveControl(this, this.phaseOffset);
        this.completedJourneys = 0;
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID, (Object)0);
        builder.define(DATA_OWNERUUID_ID, Optional.empty());
        builder.define(DATA_SCARED, (Object)false);
        builder.define(DATA_SITTING, (Object)false);
        builder.define(DATA_SHIELD, (Object)2);
        builder.define(BLOCK_POS, Optional.empty());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
        compound.putString("Type", this.getVariant().getSerializedName());
        compound.putBoolean("Sitting", ((Boolean)this.entityData.get(DATA_SITTING)).booleanValue());
        compound.putFloat("Offset", this.phaseOffset);
        compound.putInt("Shield", ((Integer)this.entityData.get(DATA_SHIELD)).intValue());
        if (this.getTargetBiomeBlockPos().isPresent()) {
            compound.putLong("BlockPos", this.getTargetBiomeBlockPos().get().asLong());
        }
        compound.putInt("CompletedJourneys", this.completedJourneys);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        this.setVariant(Variant.byName(compound.getString("Type")));
        this.entityData.set(DATA_SITTING, (Object)compound.getBoolean("Sitting"));
        this.entityData.set(DATA_SHIELD, (Object)compound.getInt("Shield"));
        this.phaseOffset = compound.getFloat("Offset");
        if (compound.contains("BlockPos")) {
            this.setTargetBlockPos(Optional.of(BlockPos.of((long)compound.getLong("BlockPos"))));
        }
        this.completedJourneys = compound.getInt("CompletedJourneys");
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (!this.level().isClientSide() && dataAccessor.equals(DATA_SCARED) && this.getOwner() != null && ((Boolean)this.entityData.get(DATA_SCARED)).booleanValue()) {
            PlatformHandler.PLATFORM_HANDLER.sendToPlayer(new WayfinderCloseScreenPacket(), (Player)this.getOwner());
        }
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        return navigation;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@NotNull Player player) {
        this.setOwnerUUID(player.getUUID());
        PlatformHandler.PLATFORM_HANDLER.setWayfinder(player, this.getUUID());
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).triggerableAnim("searching_start", SEARCHING_START).triggerableAnim("searching_end", SEARCHING_END).triggerableAnim("idle", IDLE_1).triggerableAnim("idle2", IDLE_2).triggerableAnim("idle3", IDLE_3));
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        boolean finished;
        if (this.isDeadOrDying()) {
            return event.setAndContinue(DEATH);
        }
        if (this.isScared()) {
            return event.setAndContinue(SCARED);
        }
        AnimationController controller = event.getController();
        RawAnimation currentAnimation = controller.getCurrentRawAnimation();
        boolean bl = finished = controller.hasAnimationFinished() || currentAnimation == null;
        if (this.isSitting()) {
            if (finished || !currentAnimation.equals((Object)SIT_IDLE_1) && !currentAnimation.equals((Object)SIT_IDLE_2) && !currentAnimation.equals((Object)SIT_IDLE_3) && !currentAnimation.equals((Object)SIT_IDLE_4)) {
                return switch (this.getRandom().nextInt(4)) {
                    case 0 -> event.setAndContinue(SIT_IDLE_3);
                    case 1 -> event.setAndContinue(SIT_IDLE_2);
                    case 2 -> event.setAndContinue(SIT_IDLE_4);
                    default -> event.setAndContinue(SIT_IDLE_1);
                };
            }
            return PlayState.CONTINUE;
        }
        if (this.isSearching() && currentAnimation != null && !currentAnimation.equals((Object)SEARCHING_START) && !currentAnimation.equals((Object)SEARCHING_END)) {
            return event.setAndContinue(SEARCHING_LOOP);
        }
        if (finished || !currentAnimation.equals((Object)IDLE_1) && !currentAnimation.equals((Object)IDLE_2) && !currentAnimation.equals((Object)IDLE_3) && !currentAnimation.equals((Object)IDLE_4) && !currentAnimation.equals((Object)IDLE_5)) {
            return switch (this.getRandom().nextInt(35)) {
                case 0 -> event.setAndContinue(IDLE_3);
                case 1, 2, 3, 4, 5 -> event.setAndContinue(IDLE_4);
                case 6, 7, 8, 9, 10 -> event.setAndContinue(IDLE_5);
                case 11, 12, 13, 14, 15 -> event.setAndContinue(IDLE_2);
                default -> event.setAndContinue(IDLE_1);
            };
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isScared()) {
                return InteractionResult.FAIL;
            }
            if (player.getItemInHand(hand).is(Items.GLOW_BERRIES)) {
                this.playSound(SoundEvents.GENERIC_EAT);
                if (this.getHealth() < this.getMaxHealth()) {
                    this.setHealth(this.getHealth() + 1.0f);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)14);
                }
                player.getItemInHand(hand).shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (player.getUUID().equals(this.getOwnerUUID())) {
                if (this.foundBiomeTick + Wayfinder.CONFIG.wayfinder.COOLDOWN.value() * 20 > serverLevel.getServer().getTickCount()) {
                    this.no();
                    serverLevel.broadcastEntityEvent((Entity)this, (byte)13);
                    return InteractionResult.FAIL;
                }
                ArrayList<ResourceLocation> biomeList = new ArrayList<ResourceLocation>();
                for (Holder key : serverLevel.getChunkSource().getGenerator().getBiomeSource().possibleBiomes()) {
                    if (key.is(WayfinderBiomeTags.WAYFINDER_EXCLUDED)) continue;
                    key.unwrapKey().ifPresent(biome -> biomeList.add(biome.location()));
                }
                ResourceLocation current = this.getTargetBiomeBlockPos().isEmpty() ? Wayfinder.id("clear_packet") : ((ResourceKey)serverLevel.getBiome(this.getTargetBiomeBlockPos().get()).unwrapKey().get()).location();
                PlatformHandler.PLATFORM_HANDLER.sendToPlayer(new WayfinderOpenScreenPacket(biomeList, current, this.isSitting()), player);
                return InteractionResult.SUCCESS;
            }
            if (this.getOwner() == null && !PlatformHandler.PLATFORM_HANDLER.hasWayfinder(player)) {
                this.setOwner(player);
                return this.mobInteract(player, hand);
            }
            this.no();
            return InteractionResult.FAIL;
        }
        return super.mobInteract(player, hand);
    }

    public void startBiomeSearch(ResourceLocation biome) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        if (serverLevel.getBiome(this.blockPosition()).is(biome)) {
            this.no();
            return;
        }
        this.triggerAnim("controller", "searching_start");
        CompletableFuture.runAsync(() -> {
            Pair value = serverLevel.findClosestBiome3d(biomeHolder -> biomeHolder.is(biome), this.blockPosition(), Wayfinder.CONFIG.wayfinder.MAX_SEARCH_DISTANCE.value().intValue(), 32, 64);
            if (value != null) {
                this.setTargetBlockPos(Optional.of((BlockPos)value.getFirst()));
                this.foundBiomeTick = this.getServer().getTickCount();
                this.triggerAnim("controller", "searching_end");
                this.playSound(SoundEvents.ENCHANTMENT_TABLE_USE);
            } else {
                this.no();
            }
        });
    }

    public void no() {
        this.triggerAnim("controller", "no");
        this.playSound(WayfinderSounds.WAYFINDER_NO.get());
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void sit() {
        this.setSitting(true);
    }

    public void stand() {
        this.triggerAnim("controller", "idle" + (this.getRandom().nextInt(3) + 1));
        this.setSitting(false);
    }

    public int getCompletedJourneys() {
        return this.completedJourneys;
    }

    public void incrementCompletedJourneys() {
        ++this.completedJourneys;
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(DATA_SITTING);
    }

    private void setSitting(boolean sitting) {
        this.entityData.set(DATA_SITTING, (Object)sitting);
    }

    public boolean isSearching() {
        return this.getTargetBiomeBlockPos().isPresent();
    }

    public boolean isScared() {
        return (Boolean)this.entityData.get(DATA_SCARED);
    }

    public void setScared(boolean scared) {
        this.entityData.set(DATA_SCARED, (Object)scared);
    }

    public SHIELD shield() {
        return SHIELD.byHits((Integer)this.entityData.get(DATA_SHIELD));
    }

    public void setShield(SHIELD shield) {
        this.entityData.set(DATA_SHIELD, (Object)shield.hits());
    }

    public boolean hasShield() {
        return this.shield() != SHIELD.NONE;
    }

    public Optional<BlockPos> getTargetBiomeBlockPos() {
        return (Optional)this.entityData.get(BLOCK_POS);
    }

    public void setTargetBlockPos(Optional<BlockPos> pos) {
        this.entityData.set(BLOCK_POS, pos);
    }

    public final boolean unableToMoveToOwner() {
        return this.isSitting() || this.isPassenger() || this.getOwner() == null || this.getOwner().isSpectator() || this.getOwner().isDeadOrDying() || this.getTargetBiomeBlockPos().isPresent();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.GRAVITY, 0.06).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, 3.0).add(Attributes.MOVEMENT_SPEED, 2.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.0);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return WayfinderSounds.WAYFINDER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return this.getRandom().nextBoolean() ? WayfinderSounds.WAYFINDER_HURT0.get() : WayfinderSounds.WAYFINDER_HURT1.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (Wayfinder.CONFIG.wayfinder.DISABLE_SOUNDS_WHEN_SITTING.value().booleanValue() || this.getRandom().nextBoolean()) {
            return SoundEvents.EMPTY;
        }
        if (this.isScared()) {
            return WayfinderSounds.WAYFINDER_SCARED.get();
        }
        return switch (this.getRandom().nextInt(7)) {
            case 0 -> WayfinderSounds.WAYFINDER_IDLE0.get();
            case 1 -> WayfinderSounds.WAYFINDER_IDLE1.get();
            case 2 -> WayfinderSounds.WAYFINDER_IDLE2.get();
            case 3 -> WayfinderSounds.WAYFINDER_IDLE3.get();
            case 4 -> WayfinderSounds.WAYFINDER_IDLE4.get();
            case 5 -> WayfinderSounds.WAYFINDER_IDLE5.get();
            default -> SoundEvents.AMETHYST_BLOCK_CHIME;
        };
    }

    public boolean isSilent() {
        return super.isSilent() || Wayfinder.CONFIG.wayfinder.ENABLE_SOUNDS.value() == false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal(this, 1.0, 5.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new GoToPosGoal(this, this.getOwner(), this.getTargetBiomeBlockPos(), 2.5));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new ScaredWayfinderGoal(this));
        this.goalSelector.addGoal(5, (Goal)new ShieldRegenGoal(this));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void updateControlFlags() {
        super.updateControlFlags();
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, !this.isScared() && !this.isSitting());
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, !this.isScared() && !this.isSitting());
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        boolean hurt;
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.isScared()) {
            if (this.shield() == SHIELD.FULL) {
                this.setShield(SHIELD.HALF);
                this.playSound(WayfinderSounds.WAYFINDER_SHIELD_HIT.get());
                return false;
            }
            if (this.shield() == SHIELD.HALF) {
                this.setShield(SHIELD.NONE);
                this.playSound(WayfinderSounds.WAYFINDER_SHIELD_BREAK.get());
                return false;
            }
        }
        if (hurt = super.hurt(source, amount)) {
            Entity entity;
            this.setScared(true);
            if (this.isDeadOrDying() && this.getOwner() != null && source.getEntity() != null && (entity = source.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (this.getOwner().is((Entity)player)) {
                    WayfinderCriteriaTriggers.WAYFINDER_OWNER_KILLED.get().trigger(player);
                }
            }
        }
        return hurt;
    }

    public void gameEvent(@NotNull Holder<GameEvent> gameEvent, @Nullable Entity entity) {
        super.gameEvent(gameEvent, entity);
        if (entity != null && entity.is((Entity)this) && gameEvent.is(GameEvent.ENTITY_DIE.key())) {
            Player owner = (Player)this.getOwner();
            if (owner == null) {
                return;
            }
            PlatformHandler.PLATFORM_HANDLER.sendToPlayer(new WayfinderCloseScreenPacket(), owner);
            PlatformHandler.PLATFORM_HANDLER.setWayfinder(owner, Util.NIL_UUID);
            PlatformHandler.PLATFORM_HANDLER.incrementWayfinderDeaths(owner);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        } else if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HEART);
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double e = this.random.nextGaussian() * 0.02;
            double f = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOption, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d, e, f);
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingEntity = this.getOwner();
        return livingEntity != null && this.distanceToSqr((Entity)livingEntity) >= 288.0;
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity != null) {
            this.teleportToAroundBlockPos(livingEntity.blockPosition());
        }
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandom().nextIntBetweenInclusive(-3, 3);
            int k = this.getRandom().nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.getRandom().nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        if (WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)pos) != PathType.WALKABLE) {
            return false;
        }
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(pos.subtract((Vec3i)this.blockPosition())));
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_TYPE_ID, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_TYPE_ID));
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT(0, "default"),
        LUSH(1, "lush"),
        MUSHROOM(2, "mushroom"),
        BWG(3, "bwg");

        public static final StringRepresentable.EnumCodec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byName(String name) {
            return (Variant)CODEC.byName(name, (Enum)DEFAULT);
        }

        public static Variant byId(int index) {
            return BY_ID.apply(index);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static enum SHIELD {
        FULL(2),
        HALF(1),
        NONE(0);

        private final int hits;

        private SHIELD(int hits) {
            this.hits = hits;
        }

        public int hits() {
            return this.hits;
        }

        public static SHIELD byHits(int hits) {
            return switch (hits) {
                case 2 -> FULL;
                case 1 -> HALF;
                default -> NONE;
            };
        }
    }
}

